/*
 * Decompiled with CFR 0.152.
 */
package com.alamos.ObjektImportTool.runner.data;

import com.alamos.ObjektImportTool.runner.data.FoundObject;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class FoundObject
implements Comparable<FoundObject> {
    private String name;
    private FoundObject parent;
    private Path alarmPlan;
    private Path objectData;
    private boolean alarmPlanOnlyDoc;
    private boolean objectDataOnlyDoc;
    private List<FoundObject> children;

    public String toString(Path baseFolder) {
        StringBuilder builder = new StringBuilder();
        if (this.alarmPlan != null) {
            builder.append(this.alarmPlanOnlyDoc ? "\ud83d\udfe1" : "\u2705");
        } else {
            builder.append("\ud83d\udd34");
        }
        if (this.objectData != null) {
            builder.append(this.objectDataOnlyDoc ? "\ud83d\udfe1" : "\u2705");
        } else {
            builder.append("\ud83d\udd34");
        }
        builder.append(" ");
        if (this.parent != null) {
            builder.append("--> [(").append(this.parent.getName()).append(") ");
        } else {
            builder.append("[");
        }
        builder.append(this.name);
        builder.append("]");
        if (this.alarmPlan != null) {
            builder.append(", Alarmplan: ");
            builder.append(this.removeBaseFolderForLogging(baseFolder, this.alarmPlan));
        }
        if (this.objectData != null) {
            builder.append(", Objektdaten: ");
            builder.append(this.removeBaseFolderForLogging(baseFolder, this.objectData));
        }
        return builder.toString();
    }

    private String removeBaseFolderForLogging(Path baseFolder, Path file) {
        return file.toString().replaceFirst(Pattern.quote(baseFolder.toString()), "");
    }

    @Override
    public int compareTo(FoundObject o) {
        return StringUtils.compare((String)this.name, (String)o.name);
    }

    @Generated
    private static List<FoundObject> $default$children() {
        return new ArrayList<FoundObject>();
    }

    @Generated
    FoundObject(String name, FoundObject parent, Path alarmPlan, Path objectData, boolean alarmPlanOnlyDoc, boolean objectDataOnlyDoc, List<FoundObject> children) {
        this.name = name;
        this.parent = parent;
        this.alarmPlan = alarmPlan;
        this.objectData = objectData;
        this.alarmPlanOnlyDoc = alarmPlanOnlyDoc;
        this.objectDataOnlyDoc = objectDataOnlyDoc;
        this.children = children;
    }

    @Generated
    public static FoundObjectBuilder builder() {
        return new FoundObjectBuilder();
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public FoundObject getParent() {
        return this.parent;
    }

    @Generated
    public Path getAlarmPlan() {
        return this.alarmPlan;
    }

    @Generated
    public Path getObjectData() {
        return this.objectData;
    }

    @Generated
    public boolean isAlarmPlanOnlyDoc() {
        return this.alarmPlanOnlyDoc;
    }

    @Generated
    public boolean isObjectDataOnlyDoc() {
        return this.objectDataOnlyDoc;
    }

    @Generated
    public List<FoundObject> getChildren() {
        return this.children;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setParent(FoundObject parent) {
        this.parent = parent;
    }

    @Generated
    public void setAlarmPlan(Path alarmPlan) {
        this.alarmPlan = alarmPlan;
    }

    @Generated
    public void setObjectData(Path objectData) {
        this.objectData = objectData;
    }

    @Generated
    public void setAlarmPlanOnlyDoc(boolean alarmPlanOnlyDoc) {
        this.alarmPlanOnlyDoc = alarmPlanOnlyDoc;
    }

    @Generated
    public void setObjectDataOnlyDoc(boolean objectDataOnlyDoc) {
        this.objectDataOnlyDoc = objectDataOnlyDoc;
    }

    @Generated
    public void setChildren(List<FoundObject> children) {
        this.children = children;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FoundObject)) {
            return false;
        }
        FoundObject other = (FoundObject)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isAlarmPlanOnlyDoc() != other.isAlarmPlanOnlyDoc()) {
            return false;
        }
        if (this.isObjectDataOnlyDoc() != other.isObjectDataOnlyDoc()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        FoundObject this$parent = this.getParent();
        FoundObject other$parent = other.getParent();
        if (this$parent == null ? other$parent != null : !this$parent.equals(other$parent)) {
            return false;
        }
        Path this$alarmPlan = this.getAlarmPlan();
        Path other$alarmPlan = other.getAlarmPlan();
        if (this$alarmPlan == null ? other$alarmPlan != null : !((Object)this$alarmPlan).equals(other$alarmPlan)) {
            return false;
        }
        Path this$objectData = this.getObjectData();
        Path other$objectData = other.getObjectData();
        if (this$objectData == null ? other$objectData != null : !((Object)this$objectData).equals(other$objectData)) {
            return false;
        }
        List this$children = this.getChildren();
        List other$children = other.getChildren();
        return !(this$children == null ? other$children != null : !((Object)this$children).equals(other$children));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FoundObject;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAlarmPlanOnlyDoc() ? 79 : 97);
        result = result * 59 + (this.isObjectDataOnlyDoc() ? 79 : 97);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        FoundObject $parent = this.getParent();
        result = result * 59 + ($parent == null ? 43 : $parent.hashCode());
        Path $alarmPlan = this.getAlarmPlan();
        result = result * 59 + ($alarmPlan == null ? 43 : ((Object)$alarmPlan).hashCode());
        Path $objectData = this.getObjectData();
        result = result * 59 + ($objectData == null ? 43 : ((Object)$objectData).hashCode());
        List $children = this.getChildren();
        result = result * 59 + ($children == null ? 43 : ((Object)$children).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "FoundObject(name=" + this.getName() + ", parent=" + String.valueOf(this.getParent()) + ", alarmPlan=" + String.valueOf(this.getAlarmPlan()) + ", objectData=" + String.valueOf(this.getObjectData()) + ", alarmPlanOnlyDoc=" + this.isAlarmPlanOnlyDoc() + ", objectDataOnlyDoc=" + this.isObjectDataOnlyDoc() + ", children=" + String.valueOf(this.getChildren()) + ")";
    }
}

