/*
 * Decompiled with CFR 0.152.
 */
package com.alamos.ObjektImportTool.runner;

import com.alamos.ObjektImportTool.cli.CliData;
import com.alamos.ObjektImportTool.csv.CsvAlarmObjectMapper;
import com.alamos.ObjektImportTool.csv.CsvCoordinateObject;
import com.alamos.ObjektImportTool.csv.CsvParsingService;
import com.alamos.ObjektImportTool.csv.FE2ImportAlarmObject;
import com.alamos.ObjektImportTool.file.DownloadedFileDetails;
import com.alamos.ObjektImportTool.http.HttpService;
import com.alamos.ObjektImportTool.runner.FileStructureRunner;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.SpringApplication;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class ImportRunner
implements ApplicationRunner {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ImportRunner.class);
    private final CliData cliData;
    private final CsvParsingService csvParsingService;
    private final HttpService httpService;
    private final ApplicationContext applicationContext;
    private final CsvAlarmObjectMapper mapper;
    private final FileStructureRunner fileStructureRunner;

    public void run(ApplicationArguments args) throws Exception {
        if (args.containsOption("api")) {
            this.mapper.initGoogleMaps(this.cliData.getGoogleMapsApiKey());
        }
        if (args.containsOption("csv")) {
            this.runFromCSV();
        } else {
            this.runFromFolder(Path.of(this.cliData.getFolder(), new String[0]));
        }
        SpringApplication.exit((ApplicationContext)this.applicationContext, (ExitCodeGenerator[])new ExitCodeGenerator[]{() -> 0});
        System.exit(0);
    }

    private void runFromFolder(Path folder) {
        this.fileStructureRunner.run(folder);
    }

    private void runFromCSV() throws Exception {
        File csvFile = new File(this.cliData.getCsv());
        List csvObjects = this.csvParsingService.parseCsv(csvFile);
        log.info("{} Objekte", (Object)csvObjects.size());
        AtomicInteger noFile = new AtomicInteger();
        List<FE2ImportAlarmObject> fe2ImportAlarmObjects = csvObjects.stream().map(arg_0 -> ((CsvAlarmObjectMapper)this.mapper).mapToFE2ImportObject(arg_0)).filter(Objects::nonNull).toList();
        if (StringUtils.isNotBlank((CharSequence)this.cliData.getCoordinates())) {
            File coordinatesFile = new File(this.cliData.getCoordinates());
            List coordinates = this.csvParsingService.parseCoordinatesCsv(coordinatesFile);
            log.info("{} Koordinaten", (Object)coordinates.size());
            fe2ImportAlarmObjects.forEach(object -> {
                Optional<CsvCoordinateObject> coordinatesOpt = coordinates.stream().filter(co -> {
                    boolean result = StringUtils.equals((CharSequence)co.getId(), (CharSequence)object.getIdent());
                    if (result) {
                        return true;
                    }
                    return StringUtils.equals((CharSequence)co.getId(), (CharSequence)object.getIdent().split(" ")[0]);
                }).findAny();
                coordinatesOpt.ifPresent(latLng -> {
                    object.setCoordsY(String.valueOf(latLng.getWsgLat()));
                    object.setCoordsX(String.valueOf(latLng.getWsgLng()));
                });
            });
        }
        fe2ImportAlarmObjects.forEach(object -> {
            if (StringUtils.isNotBlank((CharSequence)object.getCoordsX())) {
                log.info("\ud83d\udccd {} [{}] - {} | {} | {}, {}", new Object[]{object.getIdent(), object.getType(), object.getName(), object.getLocation(), object.getCoordsX(), object.getCoordsY()});
            } else {
                log.info("\u2753 {} [{}] - {} | {} | {}, {}", new Object[]{object.getIdent(), object.getType(), object.getName(), object.getLocation(), object.getCoordsX(), object.getCoordsY()});
            }
        });
        if (this.cliData.isDryRun()) {
            return;
        }
        this.httpService.postToFE2(fe2ImportAlarmObjects);
        if (StringUtils.isNotBlank((CharSequence)this.cliData.getFolder())) {
            fe2ImportAlarmObjects.forEach(object -> {
                Optional fileOpt = this.fileStructureRunner.findFile(Path.of(this.cliData.getFolder(), new String[0]), object);
                if (fileOpt.isPresent()) {
                    Path file = (Path)fileOpt.get();
                    log.info("\ud83d\udcd3 {} [{}] - {} | {} | {}", new Object[]{object.getIdent(), object.getType(), object.getName(), fileOpt, object.getLocation()});
                    DownloadedFileDetails upload = DownloadedFileDetails.builder().objectIdent(object.getIdent()).name(file.toFile().getName()).localFile(file.toFile()).build();
                    try {
                        this.httpService.uploadFile(upload);
                    }
                    catch (Exception e) {
                        log.error("Upload for {} in object {} failed: {}", new Object[]{upload.getName(), object.getName(), e.getLocalizedMessage(), e});
                    }
                } else {
                    noFile.getAndIncrement();
                    log.info("\u2753 {} [{}] - {} | {} | {}", new Object[]{object.getIdent(), object.getType(), object.getName(), fileOpt, object.getLocation()});
                }
            });
        }
    }

    @Generated
    public ImportRunner(CliData cliData, CsvParsingService csvParsingService, HttpService httpService, ApplicationContext applicationContext, CsvAlarmObjectMapper mapper, FileStructureRunner fileStructureRunner) {
        this.cliData = cliData;
        this.csvParsingService = csvParsingService;
        this.httpService = httpService;
        this.applicationContext = applicationContext;
        this.mapper = mapper;
        this.fileStructureRunner = fileStructureRunner;
    }
}

