/*
 * Decompiled with CFR 0.152.
 */
package com.alamos.ObjektImportTool.runner;

import com.alamos.ObjektImportTool.csv.FE2ImportAlarmObject;
import com.alamos.ObjektImportTool.runner.data.FoundObject;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class FileStructureRunner {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FileStructureRunner.class);

    public void run(Path folder) {
        ArrayList objects = new ArrayList();
        log.info("Running in folder {}", (Object)folder);
        try (Stream<Path> paths = Files.walk(folder, 1, new FileVisitOption[0]);){
            paths.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).forEach(object -> {
                if (object.equals(folder)) {
                    return;
                }
                log.info("Searching in {}...", (Object)object.getFileName());
                FoundObject foundObject = FoundObject.builder().name(object.getFileName().toString()).build();
                objects.add(foundObject);
                this.searchForOriginalFolder(object, foundObject);
            });
        }
        catch (IOException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
        }
        log.info("Found {} Objects", (Object)objects.size());
        objects.stream().sorted().forEach(object -> {
            log.info(object.toString(folder));
            object.getChildren().forEach(child -> log.info(child.toString(folder)));
        });
    }

    private void searchForOriginalFolder(Path object, FoundObject foundObject) {
        try (Stream<Path> paths = Files.walk(object, new FileVisitOption[0]);){
            List<Path> originalFolders = paths.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).filter(p -> p.getFileName().toString().equals("Originale")).toList();
            if (originalFolders.size() == 1) {
                this.findAlarmAndObjectPlan(foundObject, originalFolders.getFirst());
            } else {
                originalFolders.forEach(originalFolder -> {
                    FoundObject child = FoundObject.builder().name(originalFolder.getParent().getFileName().toString()).parent(foundObject).build();
                    this.findAlarmAndObjectPlan(child, originalFolder);
                    foundObject.getChildren().add(child);
                });
            }
        }
        catch (IOException e) {
            log.error("Issues finding originals with {}: {}", (Object)foundObject.getName(), (Object)e.getLocalizedMessage());
        }
    }

    private void findAlarmAndObjectPlan(FoundObject foundObject, Path originalFolder) {
        this.findAlarmPlan(originalFolder, foundObject, ".pdf");
        if (foundObject.getAlarmPlan() == null) {
            this.findAlarmPlan(originalFolder, foundObject, ".doc");
        }
        if (foundObject.getAlarmPlan() == null) {
            this.findAlarmPlan(originalFolder, foundObject, ".docx");
        }
        this.findObjectData(originalFolder, foundObject, ".pdf");
        if (foundObject.getObjectData() == null) {
            this.findObjectData(originalFolder, foundObject, ".doc");
        }
        if (foundObject.getObjectData() == null) {
            this.findObjectData(originalFolder, foundObject, ".docx");
        }
    }

    private void findAlarmPlan(Path originalFolder, FoundObject foundObject, String fileEnding) {
        try (Stream<Path> paths = Files.walk(originalFolder, new FileVisitOption[0]);){
            List<Path> alarmplans = paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> p.getFileName().toString().endsWith(fileEnding)).filter(p -> p.getFileName().toString().contains("Alarmplan")).sorted(FileStructureRunner.getLastModifiedTimeComparator()).toList();
            if (alarmplans.isEmpty()) {
                throw new IOException("Could not find alarmplan");
            }
            foundObject.setAlarmPlan(alarmplans.getFirst());
            if (!StringUtils.equals((CharSequence)".pdf", (CharSequence)fileEnding)) {
                foundObject.setAlarmPlanOnlyDoc(true);
            }
        }
        catch (IOException e) {
            log.error("Issues with finding alarmplan {}: {}", (Object)foundObject.getName(), (Object)e.getLocalizedMessage());
        }
    }

    private void findObjectData(Path originalFolder, FoundObject foundObject, String fileEnding) {
        try (Stream<Path> paths = Files.walk(originalFolder, new FileVisitOption[0]);){
            List<Path> objectDatas = paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> p.getFileName().toString().endsWith(fileEnding)).filter(p -> p.getFileName().toString().contains("Objektdaten")).sorted(FileStructureRunner.getLastModifiedTimeComparator()).toList();
            if (objectDatas.isEmpty()) {
                throw new IOException("Could not find object-data");
            }
            foundObject.setObjectData(objectDatas.getFirst());
            if (!StringUtils.equals((CharSequence)".pdf", (CharSequence)fileEnding)) {
                foundObject.setObjectDataOnlyDoc(true);
            }
        }
        catch (IOException e) {
            log.error("Issues with finding object-data {}: {}", (Object)foundObject.getName(), (Object)e.getLocalizedMessage());
        }
    }

    private static Comparator<Path> getLastModifiedTimeComparator() {
        return (path1, path2) -> {
            try {
                return Files.getLastModifiedTime(path2, new LinkOption[0]).compareTo(Files.getLastModifiedTime(path1, new LinkOption[0]));
            }
            catch (IOException iOException) {
                return 0;
            }
        };
    }

    public Optional<Path> findFile(Path parent, FE2ImportAlarmObject object) {
        String id = (String)object.getKeyValue().get("Plan-Nummer");
        String wache = (String)object.getKeyValue().get("Wache");
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{id, wache})) {
            if (id.startsWith("0-")) {
                wache = "0-Pl\u00e4ne";
            } else if (id.startsWith("6-")) {
                wache = "6-Pl\u00e4ne";
            } else {
                return Optional.empty();
            }
        }
        Path wacheFolder = parent.resolve(wache);
        Path file = wacheFolder.resolve("%s FW-Einsatzplan.pdf".formatted(id));
        if (Files.exists(file, new LinkOption[0])) {
            return Optional.of(file);
        }
        return Optional.empty();
    }
}

