/*
 * Decompiled with CFR 0.152.
 */
package com.alamos.ObjektImportTool.http;

import com.alamos.ObjektImportTool.cli.CliData;
import com.alamos.ObjektImportTool.csv.FE2ImportAlarmObject;
import com.alamos.ObjektImportTool.file.DownloadedFileDetails;
import com.alamos.ObjektImportTool.http.HttpService;
import com.alamos.ObjektImportTool.http.requests.LoginRequest;
import com.alamos.ObjektImportTool.http.responses.LoginTokenResponse;
import com.alamos.ObjektImportTool.http.responses.ObjectsUpdatedResponse;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.security.SecureRandom;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.Call;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class HttpService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ObjectMapper objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    private final OkHttpClient okHttpClient;
    private final CliData cliData;
    private String token;

    public HttpService(CliData cliData) throws Exception {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        1 TRUST_ALL_CERTS = new /* Unavailable Anonymous Inner Class!! */;
        SSLContext sslContext = SSLContext.getInstance("SSL");
        sslContext.init(null, new TrustManager[]{TRUST_ALL_CERTS}, new SecureRandom());
        builder.sslSocketFactory(sslContext.getSocketFactory(), (X509TrustManager)TRUST_ALL_CERTS);
        this.okHttpClient = builder.build();
        this.cliData = cliData;
    }

    public void postToFE2(List<FE2ImportAlarmObject> alarmObjectList) throws Exception {
        String url = String.format("%s/rest/objektTool/sync?convertCoords=false", this.cliData.getHost());
        RequestBody body = RequestBody.create((String)this.objectMapper.writeValueAsString(alarmObjectList), (MediaType)MediaType.parse((String)"application/json"));
        Request request = new Request.Builder().url(url).addHeader("Authorization", this.getJwtWithLogin()).post(body).build();
        Call call = this.okHttpClient.newCall(request);
        Response response = call.execute();
        if (response.isSuccessful()) {
            ObjectsUpdatedResponse stats = (ObjectsUpdatedResponse)this.objectMapper.readValue(response.body().string(), ObjectsUpdatedResponse.class);
            if (stats == null) {
                this.logger.warn("Response-Body ist unerwartet null");
                return;
            }
            response.close();
            this.logger.info("Synchronisation abgeschlossen: {} Objekte neu angelegt, {} ge\u00e4ndert und {} gel\u00f6scht", new Object[]{stats.getCreated(), stats.getUpdated(), stats.getDeleted()});
            return;
        }
    }

    private String getJwtWithLogin() throws Exception {
        if (StringUtils.isBlank((CharSequence)this.token)) {
            this.token = this.login();
        }
        return "JWT " + this.token;
    }

    private String login() throws Exception {
        LoginTokenResponse tokenResponse;
        String url = String.format("%s/rest/login", this.cliData.getHost());
        this.logger.info(url);
        RequestBody body = RequestBody.create((String)this.objectMapper.writeValueAsString((Object)new LoginRequest(this.cliData.getUsername(), this.cliData.getPassword())), (MediaType)MediaType.parse((String)"application/json"));
        Request request = new Request.Builder().url(url).post(body).build();
        Call call = this.okHttpClient.newCall(request);
        try (Response response = call.execute();){
            if (!response.isSuccessful()) {
                throw new Exception("Fehler beim Login, Status: " + response.code());
            }
            tokenResponse = (LoginTokenResponse)this.objectMapper.readValue(response.body().string(), LoginTokenResponse.class);
        }
        if (tokenResponse != null && StringUtils.isNotBlank((CharSequence)tokenResponse.getToken())) {
            this.logger.info("Login als Organisation {} erfolgreich", (Object)this.cliData.getUsername());
            return tokenResponse.getToken();
        }
        throw new Exception("Fehler beim Login: Antwort war ung\u00fcltig");
    }

    public void uploadFile(DownloadedFileDetails downloadedFileDetails) throws Exception {
        if (downloadedFileDetails.getLocalFile() == null || !downloadedFileDetails.getLocalFile().exists()) {
            this.logger.debug("Datei {} existiert nicht und wird \u00fcbersprungen", (Object)downloadedFileDetails.toLocalFilename());
            return;
        }
        MultipartBody requestBody = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("file", downloadedFileDetails.getLocalFile().getName(), RequestBody.create((File)downloadedFileDetails.getLocalFile(), (MediaType)MediaType.parse((String)"application/pdf"))).addFormDataPart("id", downloadedFileDetails.getObjectIdent()).addFormDataPart("name", downloadedFileDetails.getLocalFile().getName()).addFormDataPart("lastModified", String.valueOf(downloadedFileDetails.getLocalFile().lastModified())).build();
        String url = String.format("%s/rest/objektTool/upload", this.cliData.getHost());
        Request request = new Request.Builder().url(url).addHeader("Authorization", this.getJwtWithLogin()).post((RequestBody)requestBody).build();
        Call call = this.okHttpClient.newCall(request);
        Response response = call.execute();
        if (response.isSuccessful()) {
            this.logger.info("\u2705 {}", (Object)downloadedFileDetails.getName());
        } else {
            this.logger.warn("\u26d4\ufe0f {}:{}", (Object)downloadedFileDetails.getName(), (Object)response.code());
        }
        response.close();
    }
}

