/*
 * Decompiled with CFR 0.152.
 */
package com.alamos.ObjektImportTool.http;

import com.google.maps.GeoApiContext;
import com.google.maps.GeocodingApi;
import com.google.maps.model.GeocodingResult;
import com.google.maps.model.LatLng;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class GoogleMapsService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GoogleMapsService.class);
    GeoApiContext context;

    public void initContext(String apiKey) {
        log.info("Using API Key '{}'", (Object)apiKey);
        this.context = new GeoApiContext.Builder().apiKey(apiKey).build();
    }

    public boolean hasContext() {
        return this.context != null;
    }

    public LatLng getCoordinates(String location) throws Exception {
        log.info("Running geocoding for '{}'", (Object)location);
        GeocodingResult[] results = (GeocodingResult[])GeocodingApi.geocode((GeoApiContext)this.context, (String)location).region("de").awaitIgnoreError();
        if (results != null && results.length > 0) {
            LatLng result = results[0].geometry.location;
            log.info("Geocoding result for '{}': {}, {}", new Object[]{location, result.lat, result.lng});
            return result;
        }
        log.warn("Results for {} empty!", (Object)location);
        throw new Exception("Location not found");
    }
}

