/*
 * Decompiled with CFR 0.152.
 */
package com.alamos.ObjektImportTool.csv;

import com.alamos.ObjektImportTool.csv.CsvAlarmObject;
import com.alamos.ObjektImportTool.csv.CsvCoordinateObject;
import com.alamos.ObjektImportTool.data.UTM;
import com.alamos.ObjektImportTool.data.WGS84;
import com.opencsv.bean.CsvToBean;
import com.opencsv.bean.CsvToBeanBuilder;
import com.opencsv.bean.HeaderColumnNameMappingStrategy;
import com.opencsv.bean.MappingStrategy;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CsvParsingService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CsvParsingService.class);

    public List<CsvCoordinateObject> parseCoordinatesCsv(File csvFile) throws IOException {
        log.info("Koordinaten CSV wird unter {} eingelesen", (Object)csvFile.getAbsolutePath());
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(csvFile), "Cp1252"));
        HeaderColumnNameMappingStrategy ms = new HeaderColumnNameMappingStrategy();
        ms.setType(CsvCoordinateObject.class);
        CsvToBean csvToBean = new CsvToBeanBuilder((Reader)reader).withType(CsvCoordinateObject.class).withMappingStrategy((MappingStrategy)ms).withThrowExceptions(true).withSeparator(';').build();
        List list = csvToBean.parse();
        if (!csvToBean.getCapturedExceptions().isEmpty()) {
            log.warn("Beim Laden der CSV sind Fehler aufgetreten, die Verarbeitung wurde jedoch abgeschlossen");
            csvToBean.getCapturedExceptions().forEach(e -> log.warn("Fehler: ", (Throwable)e));
        }
        reader.close();
        list.forEach(co -> {
            UTM utm = new UTM(32, 'U', (double)co.getLat(), (double)co.getLng());
            WGS84 wsg = new WGS84(utm);
            co.setWsgLat(wsg.getLatitude());
            co.setWsgLng(wsg.getLongitude());
        });
        log.info("CSV eingelesen, {} Elemente gefunden", (Object)list.size());
        return list;
    }

    public List<CsvAlarmObject> parseCsv(File csvFile) throws IOException {
        log.info("CSV wird unter {} eingelesen", (Object)csvFile.getAbsolutePath());
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(csvFile), "Cp1252"));
        HeaderColumnNameMappingStrategy ms = new HeaderColumnNameMappingStrategy();
        ms.setType(CsvAlarmObject.class);
        CsvToBean csvToBean = new CsvToBeanBuilder((Reader)reader).withType(CsvAlarmObject.class).withMappingStrategy((MappingStrategy)ms).withThrowExceptions(false).withSeparator(';').withEscapeChar('\u0000').build();
        List list = csvToBean.parse();
        if (!csvToBean.getCapturedExceptions().isEmpty()) {
            log.warn("Beim Laden der CSV sind Fehler aufgetreten, die Verarbeitung wurde jedoch abgeschlossen");
            csvToBean.getCapturedExceptions().forEach(e -> log.warn("Fehler: ", (Throwable)e));
        }
        reader.close();
        log.info("CSV eingelesen, {} Elemente gefunden", (Object)list.size());
        return list;
    }
}

