/*
 * Decompiled with CFR 0.152.
 */
package com.alamos.ObjektImportTool.csv;

import com.alamos.ObjektImportTool.csv.CsvAlarmObject;
import com.alamos.ObjektImportTool.csv.FE2ImportAlarmObject;
import com.alamos.ObjektImportTool.data.AlarmObjectRisk;
import com.alamos.ObjektImportTool.data.AlarmObjectRiskSubstance;
import com.alamos.ObjektImportTool.data.AlarmObjectRisks;
import com.alamos.ObjektImportTool.data.ERiskClass;
import com.alamos.ObjektImportTool.http.GoogleMapsService;
import com.google.maps.model.LatLng;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CsvAlarmObjectMapper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CsvAlarmObjectMapper.class);
    private final GoogleMapsService googleMapsService;

    @Autowired
    public CsvAlarmObjectMapper(GoogleMapsService googleMapsService) {
        this.googleMapsService = googleMapsService;
    }

    public void initGoogleMaps(String apiKey) {
        this.googleMapsService.initContext(apiKey);
    }

    public FE2ImportAlarmObject mapToFE2ImportObject(CsvAlarmObject csvObject) {
        AlarmObjectRiskSubstance substance;
        String house = csvObject.getHouse() + csvObject.getHouseAdditional();
        if (StringUtils.isBlank((CharSequence)csvObject.getPlanNummer())) {
            return null;
        }
        String planNr = csvObject.getPlanNummer();
        String ob = csvObject.getOb();
        String ident = planNr.replaceAll("-", "/");
        if (StringUtils.isNotBlank((CharSequence)ob)) {
            ident = ident.concat(" ").concat(ob);
        }
        int lat = 0;
        int lng = 0;
        FE2ImportAlarmObject.FE2ImportAlarmObjectBuilder builder = FE2ImportAlarmObject.builder().ident(ident).name(csvObject.getName()).ilsHint(this.createIlsHint(csvObject)).street(csvObject.getStreet()).house(house).city("Stuttgart").type(this.findType(csvObject.getName())).radio(this.buildRadio(csvObject)).bmaNumber(csvObject.getBma()).status("In \u00dcberarbeitung");
        StringBuilder fireWaterHint = new StringBuilder();
        ArrayList<CallSite> extinguish = new ArrayList<CallSite>();
        AlarmObjectRisks risks = new AlarmObjectRisks();
        HashMap<String, String> keyValue = new HashMap<String, String>();
        keyValue.put("Ausr\u00fcckebereich", planNr.substring(0, 1));
        keyValue.put("Wache", csvObject.getAusrueckebereich().replaceAll("Feuerwache ", "FW"));
        if (StringUtils.isNotBlank((CharSequence)csvObject.getAbweichendeAnfahrt())) {
            builder.drive("Achtung! Postadresse und Objektanfahrt NICHT identisch!");
        }
        if (StringUtils.isNotBlank((CharSequence)csvObject.getBmaKeyword())) {
            keyValue.put("Einsatzstichwort", csvObject.getBmaKeyword());
        }
        if (StringUtils.isNotBlank((CharSequence)csvObject.getFf())) {
            keyValue.put("Freiwillige Feuerwehr", csvObject.getFf());
        }
        keyValue.put("Plan-Nummer", csvObject.getPlanNummer());
        if (StringUtils.isNotBlank((CharSequence)csvObject.getAufzug())) {
            keyValue.put("FW-Aufzug", "Ja");
            builder.elevators("Zugang:FW-Aufzug vorhanden:" + lat + ":" + lng);
        }
        if (StringUtils.isNotBlank((CharSequence)csvObject.getFunk())) {
            keyValue.put("Geb\u00e4udefunk", "Ja");
        }
        if (StringUtils.isNotBlank((CharSequence)csvObject.getLowaru())) {
            keyValue.put("L\u00f6WaR\u00fc", "Ja");
            fireWaterHint.append("L\u00f6schwasserr\u00fcckhaltung beachten!\n");
        }
        if (StringUtils.isNotBlank((CharSequence)csvObject.getWanhydranten())) {
            keyValue.put("Wandhydranten", "Ja");
            fireWaterHint.append("Wandhydranten\n");
        }
        if (StringUtils.isNotBlank((CharSequence)csvObject.getSteigleitung())) {
            keyValue.put("Trockene Steigleitung", "Ja");
            fireWaterHint.append("Trockene Steigleitung\n");
        }
        if (StringUtils.isNotBlank((CharSequence)csvObject.getSprinkler())) {
            keyValue.put("Sprinkler", "Ja");
            extinguish.add((CallSite)((Object)("Sprinkler:Ort:Sprinkler:" + lat + ":" + lng)));
        }
        if (StringUtils.isNotBlank((CharSequence)csvObject.getSchaumloeschanlage())) {
            keyValue.put("Schauml\u00f6schanlage", "Ja");
            extinguish.add((CallSite)((Object)("Schaum:Ort:Schauml\u00f6schanlage:" + lat + ":" + lng)));
        }
        if (StringUtils.isNotBlank((CharSequence)csvObject.getSpruehflutanlage())) {
            keyValue.put("Spr\u00fchflutanlage", "Ja");
            extinguish.add((CallSite)((Object)("Sprinkler:Ort:Spr\u00fchflutanlage:" + lat + ":" + lng)));
        }
        if (StringUtils.isNotBlank((CharSequence)csvObject.getBerieselungsanlage())) {
            keyValue.put("Berieselungsanlage", "Ja");
            extinguish.add((CallSite)((Object)("Sprinkler:Ort:Berieselungsanlage:" + lat + ":" + lng)));
        }
        if (StringUtils.isNotBlank((CharSequence)csvObject.getCo2())) {
            keyValue.put("CO2", "Ja");
            extinguish.add((CallSite)((Object)("CO2:Ort:CO2:" + lat + ":" + lng)));
        }
        if (StringUtils.isNotBlank((CharSequence)csvObject.getN2())) {
            keyValue.put("N2", "Ja");
            extinguish.add((CallSite)((Object)("CO2:Ort:N2:" + lat + ":" + lng)));
        }
        if (StringUtils.isNotBlank((CharSequence)csvObject.getInergen())) {
            keyValue.put("Inergen", "Ja");
            extinguish.add((CallSite)((Object)("CO2:Ort:Inergen:" + lat + ":" + lng)));
        }
        if (StringUtils.isNotBlank((CharSequence)csvObject.getFm())) {
            keyValue.put("FM 200", "Ja");
            extinguish.add((CallSite)((Object)("CO2:Ort:FM 200:" + lat + ":" + lng)));
        }
        if (StringUtils.isNotBlank((CharSequence)csvObject.getArgon())) {
            keyValue.put("Argon", "Ja");
            extinguish.add((CallSite)((Object)("Argon:Ort:Argon:" + lat + ":" + lng)));
        }
        if (StringUtils.isNotBlank((CharSequence)csvObject.getNovec())) {
            keyValue.put("Novec 1230", "Ja");
            extinguish.add((CallSite)((Object)("CO2:Ort:Novec 1230:" + lat + ":" + lng)));
        }
        if (StringUtils.isNotBlank((CharSequence)csvObject.getAnsul())) {
            keyValue.put("Ansul", "Ja");
            extinguish.add((CallSite)((Object)("CO2:Ort:Ansul:" + lat + ":" + lng)));
        }
        if (StringUtils.isNotBlank((CharSequence)csvObject.getOxyreduct())) {
            keyValue.put("Oxyreduct", "Ja");
            extinguish.add((CallSite)((Object)("CO2:Ort:Oxyreduct:" + lat + ":" + lng)));
        }
        if (StringUtils.isNotBlank((CharSequence)csvObject.getKulturgut())) {
            keyValue.put("Kulturgut", "Ja");
            builder.hints("Kulturgut");
        }
        if (StringUtils.isNotBlank((CharSequence)csvObject.getAtomar())) {
            keyValue.put("Atomar", csvObject.getAtomar());
            substance = new AlarmObjectRiskSubstance();
            substance.setRisk("Atomar");
            substance.setRiskClass(ERiskClass.RADIOACTIVE_1);
            risks.getSubstances().add(substance);
        }
        if (StringUtils.isNotBlank((CharSequence)csvObject.getBiologisch())) {
            keyValue.put("Biologisch", csvObject.getBiologisch());
            substance = new AlarmObjectRiskSubstance();
            substance.setRisk("Biologisch");
            substance.setRiskClass(ERiskClass.DANGER);
            risks.getSubstances().add(substance);
        }
        if (StringUtils.isNotBlank((CharSequence)csvObject.getChemisch())) {
            keyValue.put("Chemisch", csvObject.getChemisch());
            substance = new AlarmObjectRiskSubstance();
            substance.setRisk("Chemisch");
            substance.setRiskClass(ERiskClass.TOXIC);
            risks.getSubstances().add(substance);
        }
        if (StringUtils.isNotBlank((CharSequence)csvObject.getPhotovoltaik())) {
            keyValue.put("Photovoltaik", "Ja");
            AlarmObjectRisk obj = new AlarmObjectRisk();
            obj.setNote("Photovoltaik");
            risks.getObjects().add(obj);
        }
        builder.fireWaterHint(fireWaterHint.toString().trim());
        keyValue.put("Ausr\u00fcckebereich", csvObject.getAusrueckebereich());
        builder.keyValue(keyValue);
        if (!extinguish.isEmpty()) {
            builder.extinguishingSystems(String.join((CharSequence)",", extinguish));
        }
        builder.risks(risks);
        if (this.googleMapsService.hasContext()) {
            StringBuilder addressBuilder = new StringBuilder();
            addressBuilder.append(csvObject.getStreet()).append(" ").append(house.trim()).append(", ").append("Stuttgart");
            try {
                LatLng coordinates = this.googleMapsService.getCoordinates(addressBuilder.toString().trim());
                builder.coordsX("" + coordinates.lng);
                builder.coordsY("" + coordinates.lat);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return builder.build();
    }

    private String findType(String name) {
        if ((name = name.toLowerCase(Locale.ROOT)).contains("schule")) {
            return "Schule";
        }
        if (name.contains("tunnel")) {
            return "Tunnel";
        }
        if (name.contains("flughafen")) {
            return "Flughafen";
        }
        if (name.contains("hafen")) {
            return "Hafen";
        }
        if (name.contains("s-bahn")) {
            return "Bahnhof";
        }
        if (name.contains("bahnhof")) {
            return "Bahnhof";
        }
        if (name.contains("pflege") || name.contains("senior")) {
            return "Betreutes Wohnen";
        }
        if (name.contains("asyl") || name.contains("fl\u00fcchtlingsunterkunft")) {
            return "Asylunterkunft";
        }
        if (name.contains("universit\u00e4t")) {
            return "Anderes";
        }
        if (name.contains("hotel")) {
            return "Hotel";
        }
        if (name.contains("gmbh")) {
            return "Industrie";
        }
        if (name.contains("wohnheim")) {
            return "Wohnanlage";
        }
        if (name.contains("parkhaus") || name.contains("tiefgarage")) {
            return "Parkhaus";
        }
        if (name.contains("feuerwehr")) {
            return "Feuerwache";
        }
        return "Geb\u00e4ude";
    }

    private String createIlsHint(CsvAlarmObject csvObject) {
        StringBuilder builder = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)csvObject.getBmaKeyword())) {
            builder.append("AAO: ").append(csvObject.getBmaKeyword()).append("\n");
        }
        return builder.toString().trim();
    }

    private String buildRadio(CsvAlarmObject csvObject) {
        if (StringUtils.equalsIgnoreCase((CharSequence)"x", (CharSequence)csvObject.getFunk())) {
            return "Analog::K64bG/U";
        }
        return null;
    }

    private Optional<String> fixFilename(String link) {
        if (StringUtils.isBlank((CharSequence)link)) {
            return Optional.empty();
        }
        if (!link.startsWith("file://")) {
            log.warn("Link zur Datei startet nicht mit 'file://', Datei wird nicht importiert");
            return Optional.empty();
        }
        link = link.substring(7);
        int filenameIndex = link.lastIndexOf(92);
        String filename = link.substring(filenameIndex + 1);
        return Optional.of(String.format("%s: %s", filename, link));
    }
}

