/*
 * Decompiled with CFR 0.152.
 */
package com.alamos.ObjektImportTool.cli;

import com.alamos.ObjektImportTool.cli.CliData;
import com.alamos.ObjektImportTool.cli.CliHelper;
import lombok.Generated;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.SpringApplication;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Service;

@Service
public class CliArgumentService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CliArgumentService.class);
    private CliData cliData;
    private final ApplicationContext applicationContext;

    public CliArgumentService(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Bean
    public CliData cliData(ApplicationArguments arguments) {
        String[] args = arguments.getSourceArgs();
        Options options = CliHelper.buildOptions();
        DefaultParser parser = new DefaultParser();
        log.debug("Argumente des Programmaufrufs werden verarbeitet");
        try {
            CommandLine line = parser.parse(options, args);
            this.cliData = CliHelper.toCliData((CommandLine)line);
        }
        catch (ParseException e) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("java -jar objektImportTool.jar", options, true);
            SpringApplication.exit((ApplicationContext)this.applicationContext, (ExitCodeGenerator[])new ExitCodeGenerator[]{() -> 1});
            System.exit(1);
        }
        log.debug("Argumente erfolgreich verarbeitet");
        return this.cliData;
    }
}

