/*
 * Decompiled with CFR 0.152.
 */
package de.alamos.ioespa.services.config;

import de.alamos.ioespa.data.config.ConfigFile;
import de.alamos.ioespa.data.config.EspaConfig;
import de.alamos.ioespa.helper.LoggerHelper;
import de.alamos.ioespa.helper.PropertyFileHelper;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.util.Optional;
import java.util.Properties;
import lombok.Generated;
import org.slf4j.Logger;
import org.springframework.stereotype.Component;

@Component
public class EspaConfigService {
    private final Logger logger = LoggerHelper.getLogger(this.getClass());
    private final File propertyFile = new File("config/espa.properties");
    private EspaConfig espaConfig;

    @SuppressFBWarnings(value={"CT_CONSTRUCTOR_THROW"})
    public EspaConfigService() {
        this.loadConfigFromProperties();
    }

    private void loadConfigFromProperties() {
        Optional opt = PropertyFileHelper.loadProperties((File)this.propertyFile);
        if (opt.isPresent()) {
            this.espaConfig = EspaConfig.fromProperties((Properties)((Properties)opt.get()));
            return;
        }
        this.logger.warn("Config konnte auch nicht aus Datei geladen werden, erstelle Standardkonfiguration");
        this.espaConfig = new EspaConfig();
        PropertyFileHelper.storeInFile((ConfigFile)this.espaConfig, (File)this.propertyFile);
    }

    public void setEspaConfig(EspaConfig espaConfig) {
        this.espaConfig = espaConfig;
        PropertyFileHelper.storeInFile((ConfigFile)espaConfig, (File)this.propertyFile);
    }

    @Generated
    public EspaConfig getEspaConfig() {
        return this.espaConfig;
    }
}

