/*
 * Decompiled with CFR 0.152.
 */
package de.alamos.ioespa.rest.responses.espa;

import de.alamos.ioespa.data.config.EspaConfig;
import de.alamos.ioespa.rest.responses.espa.EspaModelElement;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;

public class EspaModel {
    public static final int BAUD_300 = 300;
    public static final int BAUD_1200 = 1200;
    public static final int BAUD_2400 = 2400;
    public static final int BAUD_4800 = 4800;
    public static final int BAUD_9600 = 9600;
    public static final int DATABIT_5 = 5;
    public static final int DATABIT_6 = 6;
    public static final int DATABIT_7 = 7;
    public static final int DATABIT_8 = 8;
    private List<EspaModelElement> baudRates;
    private List<EspaModelElement> dataBits;
    private List<EspaModelElement> stopBits;
    private List<EspaModelElement> parities;
    private List<EspaModelElement> charsets;
    private EspaModelElement dtr;
    private EspaModelElement rts;

    public EspaModel(EspaConfig espaConfig) {
        this.baudRates = this.buildBaudRates(espaConfig);
        this.dataBits = this.buildDataBits(espaConfig);
        this.stopBits = this.buildStopBits(espaConfig);
        this.parities = this.buildParities(espaConfig);
        this.charsets = this.buildCharsets(espaConfig);
        this.dtr = this.buildDtr(espaConfig);
        this.rts = this.buildRts(espaConfig);
    }

    private EspaModelElement buildRts(EspaConfig espaConfig) {
        EspaModelElement element = new EspaModelElement("RTS", "rts");
        element.setSelected(espaConfig.isRts());
        return element;
    }

    private EspaModelElement buildDtr(EspaConfig espaConfig) {
        EspaModelElement element = new EspaModelElement("DTR", "dtr");
        element.setSelected(espaConfig.isDtr());
        return element;
    }

    private List<EspaModelElement> buildBaudRates(EspaConfig espaConfig) {
        int[] rates = new int[]{300, 1200, 2400, 4800, 9600};
        return Arrays.stream(rates).mapToObj(rate -> {
            EspaModelElement element = new EspaModelElement();
            element.setName(String.valueOf(rate));
            element.setValue(String.valueOf(rate));
            element.setSelected(espaConfig.getBaudRate() == rate);
            return element;
        }).collect(Collectors.toList());
    }

    private List<EspaModelElement> buildDataBits(EspaConfig espaConfig) {
        int[] rates = new int[]{5, 6, 7, 8};
        return Arrays.stream(rates).mapToObj(bits -> {
            EspaModelElement element = new EspaModelElement();
            element.setName(String.valueOf(bits));
            element.setValue(String.valueOf(bits));
            element.setSelected(espaConfig.getDatabits() == bits);
            return element;
        }).collect(Collectors.toList());
    }

    private List<EspaModelElement> buildParities(EspaConfig espaConfig) {
        ArrayList<EspaModelElement> parities = new ArrayList<EspaModelElement>();
        parities.add(new EspaModelElement("Gleich", "2"));
        parities.add(new EspaModelElement("Ungleich", "1"));
        parities.add(new EspaModelElement("Keine/Leer", "0"));
        parities.add(new EspaModelElement("Markiert", "3"));
        return parities.stream().peek(parity -> parity.setSelected(parity.getValueAsInt() == espaConfig.getParity())).collect(Collectors.toList());
    }

    private List<EspaModelElement> buildStopBits(EspaConfig espaConfig) {
        String[] rates = new String[]{"1", "1.5", "2"};
        return Arrays.stream(rates).map(bits -> {
            EspaModelElement element = new EspaModelElement();
            element.setName(bits);
            int val = EspaConfig.stringToStopBits((String)bits);
            element.setValue(String.valueOf(val));
            element.setSelected(espaConfig.getStopbits() == val);
            return element;
        }).collect(Collectors.toList());
    }

    private List<EspaModelElement> buildCharsets(EspaConfig espaConfig) {
        Set<String> charsets = Charset.availableCharsets().keySet();
        return charsets.stream().map(charset -> {
            EspaModelElement element = new EspaModelElement();
            element.setName(charset);
            element.setValue(charset);
            element.setSelected(espaConfig.getCharset().equals(charset));
            return element;
        }).collect(Collectors.toList());
    }

    @Generated
    public List<EspaModelElement> getBaudRates() {
        return this.baudRates;
    }

    @Generated
    public List<EspaModelElement> getDataBits() {
        return this.dataBits;
    }

    @Generated
    public List<EspaModelElement> getStopBits() {
        return this.stopBits;
    }

    @Generated
    public List<EspaModelElement> getParities() {
        return this.parities;
    }

    @Generated
    public List<EspaModelElement> getCharsets() {
        return this.charsets;
    }

    @Generated
    public EspaModelElement getDtr() {
        return this.dtr;
    }

    @Generated
    public EspaModelElement getRts() {
        return this.rts;
    }
}

