/*
 * Decompiled with CFR 0.152.
 */
package de.alamos.ioespa.rest.controller;

import de.alamos.ioespa.IOEspaApplication;
import de.alamos.ioespa.data.config.AppConfig;
import de.alamos.ioespa.data.config.IOCredentials;
import de.alamos.ioespa.helper.Base64ConfigHelper;
import de.alamos.ioespa.helper.LoggerHelper;
import de.alamos.ioespa.rest.requests.StringConfigRequest;
import de.alamos.ioespa.rest.responses.status.EAppName;
import de.alamos.ioespa.services.AppInfoService;
import de.alamos.ioespa.services.FileService;
import de.alamos.ioespa.services.MqttService;
import de.alamos.ioespa.services.config.ConfigurationService;
import de.alamos.ioespa.services.config.HttpAlarmConfigService;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
public class ConfigStringController {
    public static final int MIN_SAVED_FILES = 1;
    public static final int MAX_SAVED_FILES = 200;
    private final HttpAlarmConfigService httpAlarmConfigService;
    private final ConfigurationService configurationService;
    private final IOCredentials credentials;
    private final AppInfoService appInfoService;
    private final MqttService mqttService;
    private final FileService fileService;
    private final Logger logger = LoggerHelper.getLogger(this.getClass());

    public ConfigStringController(HttpAlarmConfigService httpAlarmConfigService, ConfigurationService configurationService, IOCredentials credentials, AppInfoService appInfoService, MqttService mqttService, FileService fileService) {
        this.httpAlarmConfigService = httpAlarmConfigService;
        this.configurationService = configurationService;
        this.credentials = credentials;
        this.appInfoService = appInfoService;
        this.mqttService = mqttService;
        this.fileService = fileService;
    }

    @GetMapping(value={"/configString"})
    public String getConfigPage(Model model, RedirectAttributes redirAttrs) {
        StringConfigRequest stringConfigRequest = new StringConfigRequest();
        AppConfig appConfig = this.configurationService.loadAppConfig();
        stringConfigRequest.setCleaningInterval(appConfig.getCleaningInterval());
        stringConfigRequest.setNumberSavedFiles(appConfig.getNumberSavedFiles());
        stringConfigRequest.setLogLevelStr(appConfig.getLogLevelStr());
        stringConfigRequest.setDuplexOn(appConfig.isDuplexOn());
        stringConfigRequest.setWebHook(appConfig.getWebHook());
        stringConfigRequest.setSecondPublicKey(appConfig.getSecondPublicKey());
        model.addAttribute("config", (Object)stringConfigRequest);
        model.addAttribute("defaultPassword", (Object)(!this.credentials.isWasChanged() ? 1 : 0));
        model.addAttribute("appName", (Object)this.appInfoService.getAppName());
        return "config";
    }

    @PostMapping(value={"/configString"})
    public String postConfig(@ModelAttribute StringConfigRequest config, RedirectAttributes redirAttrs) {
        Base64ConfigHelper configHelper;
        if (this.appInfoService.getAppName() == EAppName.IOPrint) {
            if (config.getNumberSavedFiles() < 1L || config.getNumberSavedFiles() > 200L) {
                this.logger.info("Die Anzahl der gespeicherten Dateien betr\u00e4gt {}, sollte jedoch zwischen {} und {} liegen", new Object[]{config.getNumberSavedFiles(), 1, 200});
                redirAttrs.addFlashAttribute("error", (Object)String.format("Ung\u00fcltiger Wert. Die Anzahl der gespeicherten Dateien muss zwischen %d und %d liegen", 1, 200));
                return "redirect:/status";
            }
            this.configurationService.updateAppConfig(config);
            this.fileService.deleteOldFile(config.getNumberSavedFiles());
        }
        if (StringUtils.isBlank((CharSequence)config.getContent())) {
            redirAttrs.addFlashAttribute("success", (Object)"Einstellungen erfolgreich gespeichert");
            return "redirect:/status";
        }
        try {
            configHelper = new Base64ConfigHelper(config.getContent());
        }
        catch (Exception e) {
            this.logger.info("Fehler beim Verarbeiten der Konfiguration", (Throwable)e);
            redirAttrs.addFlashAttribute("error", (Object)("Fehler beim Verarbeiten der Konfiguration: " + e.getMessage()));
            return "redirect:/status";
        }
        this.mqttService.unsubscribe();
        this.configurationService.saveConfigToFile(configHelper.getMqttConfig());
        this.configurationService.saveZipPassword(configHelper.getZipPassword());
        this.logger.info("Einstellungen wurden aktualisiert");
        redirAttrs.addFlashAttribute("success", (Object)"Einstellungen erfolgreich gespeichert. Das Programm muss neu gestartet werden um alle \u00c4nderungen zu \u00fcbernehmen");
        return "redirect:/status";
    }

    @GetMapping(value={"/reset"})
    public String resetToFactoryDefaults(RedirectAttributes redirAttrs, @RequestParam(value="Authorization") String authorization) {
        Optional macAddress = this.configurationService.getMacAddress();
        if (macAddress.isPresent()) {
            this.logger.info("MAC-Address/Provided Address: {}/{}", macAddress.get(), (Object)authorization);
            authorization = authorization.replaceAll(":", "");
            if (!((String)macAddress.get()).trim().equalsIgnoreCase(authorization)) {
                this.logger.warn("MAC-Address does not match!");
                redirAttrs.addFlashAttribute("isSerialNumberError", (Object)true);
                return "redirect:/status";
            }
        } else {
            this.logger.error("Could not determine internal MAC-Address!");
            redirAttrs.addFlashAttribute("isSerialNumberError", (Object)true);
            return "redirect:/status";
        }
        this.logger.info("MAC-Address matches!");
        this.mqttService.unsubscribe();
        this.configurationService.resetToFactoryDefaults();
        this.httpAlarmConfigService.resetToFactoryDefaults();
        IOEspaApplication.restart();
        redirAttrs.addFlashAttribute("success", (Object)"System erfolgreich zur\u00fcckgesetzt");
        return "redirect:/set_up";
    }
}

