/*
 * Decompiled with CFR 0.152.
 */
package de.alamos.ioespa.services.ioprint;

import de.alamos.firemergency.ioprint.responses.ERebootingStatus;
import de.alamos.firemergency.ioprint.responses.PrinterStatusResponse;
import de.alamos.ioespa.helper.ExecuteCommandHelper;
import de.alamos.ioespa.rest.responses.status.ESystemStatus;
import de.alamos.ioespa.rest.responses.status.StatusResponse;
import de.alamos.ioespa.services.MqttService;
import de.alamos.ioespa.services.StatusInfoService;
import de.alamos.ioespa.services.ioprint.PrinterService;
import de.alamos.ioespa.services.ioprint.predicates.PrinterErrorPredicate;
import java.util.List;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
@Profile(value={"print"})
public class IOPrintStatusInfoService {
    private final MqttService mqttService;
    private final StatusInfoService statusInfoService;
    private final PrinterService printerService;
    private final ExecuteCommandHelper commandHelper;

    public IOPrintStatusInfoService(MqttService mqttService, StatusInfoService statusInfoService, PrinterService printerService, ExecuteCommandHelper commandHelper) {
        this.mqttService = mqttService;
        this.statusInfoService = statusInfoService;
        this.printerService = printerService;
        this.commandHelper = commandHelper;
    }

    public StatusResponse getSystemStatus() {
        StatusResponse statusResponse = this.statusInfoService.getSystemStatus();
        statusResponse.setFrpRunning(false);
        statusResponse.setPrinters(this.printerService.getPrinterStatusList());
        statusResponse.setStatus(this.updateStatus(statusResponse.getStatus(), statusResponse.getPrinters()));
        statusResponse.setSubscriber(this.mqttService.getHasSubscription());
        statusResponse.setJobs(this.printerService.getRunningJobs());
        statusResponse.setIpConfig(this.commandHelper.getIpConfigAsPlainText());
        statusResponse.setNeedReboot(ERebootingStatus.NOT_NEEDED);
        statusResponse.setMqttReconnectionAttempts(this.mqttService.getReconnectionAttempts());
        statusResponse.setMqttReconnectionDelay(this.mqttService.getCurrentReconnectionDelay());
        statusResponse.setMqttReconnecting(this.mqttService.isReconnecting());
        statusResponse.setLastDisconnectTime(this.mqttService.getLastDisconnectTime());
        statusResponse.setLastSuccessfulConnection(this.mqttService.getLastSuccessfulConnection());
        return statusResponse;
    }

    private ESystemStatus updateStatus(ESystemStatus status, List<PrinterStatusResponse> printers) {
        if (ESystemStatus.ERROR.equals((Object)status)) {
            return ESystemStatus.ERROR;
        }
        if (CollectionUtils.isEmpty(printers)) {
            return ESystemStatus.ERROR;
        }
        boolean hasPrinterError = this.printerService.getPrinterStatusList().stream().anyMatch(new PrinterErrorPredicate());
        if (hasPrinterError) {
            return ESystemStatus.ERROR;
        }
        if (printers.stream().filter(PrinterStatusResponse::getEnable).findAny().isEmpty()) {
            return ESystemStatus.ERROR;
        }
        return ESystemStatus.OK;
    }
}

