/*
 * Decompiled with CFR 0.152.
 */
package de.alamos.ioespa.rest.requests;

import de.alamos.ioespa.rest.requests.PasswordChangeRequest;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class PasswordValidator {
    public static final int MIN_LENGTH = 6;
    private boolean hasDigit;
    private boolean hasCapital;
    private boolean hasLowerCase;
    private boolean length;
    private boolean passEquals;
    private boolean notEmpty;

    public boolean isValid() {
        return this.hasDigit && this.hasCapital && this.hasLowerCase && this.length && this.notEmpty && this.passEquals;
    }

    public boolean validatePass(PasswordChangeRequest request) {
        this.setNotEmpty(!StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{request.getFirst(), request.getSecond()}));
        this.setPassEquals(StringUtils.equals((CharSequence)request.getFirst(), (CharSequence)request.getSecond()));
        if (request.getFirst() == null) {
            return false;
        }
        this.setLength(request.getFirst().length() >= 6);
        boolean capitalFlag = false;
        boolean lowerCaseFlag = false;
        boolean numberFlag = false;
        for (int i = 0; i < request.getFirst().length(); ++i) {
            char ch = request.getFirst().charAt(i);
            if (Character.isDigit(ch)) {
                numberFlag = true;
                continue;
            }
            if (Character.isUpperCase(ch)) {
                capitalFlag = true;
                continue;
            }
            if (!Character.isLowerCase(ch)) continue;
            lowerCaseFlag = true;
        }
        this.setHasCapital(capitalFlag);
        this.setHasLowerCase(lowerCaseFlag);
        this.setHasDigit(numberFlag);
        return this.isValid();
    }

    @Generated
    public boolean isHasDigit() {
        return this.hasDigit;
    }

    @Generated
    public boolean isHasCapital() {
        return this.hasCapital;
    }

    @Generated
    public boolean isHasLowerCase() {
        return this.hasLowerCase;
    }

    @Generated
    public boolean isLength() {
        return this.length;
    }

    @Generated
    public boolean isPassEquals() {
        return this.passEquals;
    }

    @Generated
    public boolean isNotEmpty() {
        return this.notEmpty;
    }

    @Generated
    public void setHasDigit(boolean hasDigit) {
        this.hasDigit = hasDigit;
    }

    @Generated
    public void setHasCapital(boolean hasCapital) {
        this.hasCapital = hasCapital;
    }

    @Generated
    public void setHasLowerCase(boolean hasLowerCase) {
        this.hasLowerCase = hasLowerCase;
    }

    @Generated
    public void setLength(boolean length) {
        this.length = length;
    }

    @Generated
    public void setPassEquals(boolean passEquals) {
        this.passEquals = passEquals;
    }

    @Generated
    public void setNotEmpty(boolean notEmpty) {
        this.notEmpty = notEmpty;
    }
}

