/*
 * Decompiled with CFR 0.152.
 */
package de.alamos.ioespa.rest.controller.ioespa;

import de.alamos.ioespa.data.config.HttpAlarmConfig;
import de.alamos.ioespa.data.config.IOCredentials;
import de.alamos.ioespa.services.config.HttpAlarmConfigService;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@Profile(value={"espa"})
public class HttpConfigController {
    private final HttpAlarmConfigService configService;
    private final IOCredentials ioCredentials;

    public HttpConfigController(HttpAlarmConfigService configService, IOCredentials ioCredentials) {
        this.configService = configService;
        this.ioCredentials = ioCredentials;
    }

    @GetMapping(value={"/http"})
    public String getConfigPage(Model model, RedirectAttributes redirAttrs) {
        model.addAttribute("config", (Object)this.configService.getHttpAlarmConfig());
        model.addAttribute("defaultPassword", (Object)(!this.ioCredentials.isWasChanged() ? 1 : 0));
        return "http";
    }

    @PostMapping(value={"/http"})
    public String postConfig(@ModelAttribute HttpAlarmConfig config, RedirectAttributes redirAttrs) {
        this.configService.updateConfig(config);
        redirAttrs.addFlashAttribute("success", (Object)"HTTP-Config erfolgreich gespeichert");
        return "redirect:/status";
    }
}

