/*
 * Decompiled with CFR 0.152.
 */
package de.alamos.ioespa.rest.controller;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.alamos.ioespa.data.VersionInfo;
import de.alamos.ioespa.services.AppInfoService;
import de.alamos.ioespa.services.VersionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class VersionController {
    private final AppInfoService appInfoService;
    private final VersionService versionService;
    private final ObjectMapper objectMapper;

    @Autowired
    public VersionController(AppInfoService appInfoService, VersionService versionService) {
        this.appInfoService = appInfoService;
        this.versionService = versionService;
        this.objectMapper = new ObjectMapper();
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    @GetMapping(value={"/version"}, produces={"application/json"})
    public String getSystemVersion() throws JsonProcessingException {
        VersionInfo versionInfo = new VersionInfo(this.versionService.getCurrentVersion(), this.appInfoService.getAppName().name(), String.join((CharSequence)", ", this.appInfoService.getMacAddresses()));
        return this.objectMapper.writeValueAsString((Object)versionInfo);
    }
}

