/*
 * Decompiled with CFR 0.152.
 */
package de.alamos.ioespa.helper;

import com.alamos.security.EncryptionController;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.alamos.firemergency.ioespa.config.IOEspaStringConfig;
import de.alamos.firemergency.security.SymmetricEncryptionResult;
import de.alamos.ioespa.data.config.MqttConfig;
import de.alamos.ioespa.helper.exceptions.GenericException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.apache.commons.lang3.StringUtils;

public class Base64ConfigHelper {
    private static final String CONFIG_ENCRYPTION_PW = "8rcn}Efq`Y%RD'6Z-<x`JBD=c%-wcfr$";
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final IOEspaStringConfig mqttStringConfig;

    @SuppressFBWarnings(value={"CT_CONSTRUCTOR_THROW"})
    public Base64ConfigHelper(String base64config) throws Exception {
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        String json = new String(Base64.getDecoder().decode(base64config), StandardCharsets.UTF_8);
        SymmetricEncryptionResult encryptedResult = (SymmetricEncryptionResult)this.objectMapper.readValue(json, SymmetricEncryptionResult.class);
        String resultJson = EncryptionController.getInstance().decryptSymmetric(encryptedResult, CONFIG_ENCRYPTION_PW);
        this.mqttStringConfig = this.toConfig(resultJson);
    }

    private IOEspaStringConfig toConfig(String json) throws JsonProcessingException, GenericException {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new GenericException("Base64-String darf nicht leer sein");
        }
        return (IOEspaStringConfig)this.objectMapper.readValue(json, IOEspaStringConfig.class);
    }

    public MqttConfig getMqttConfig() {
        MqttConfig mqttConfig = new MqttConfig();
        mqttConfig.setMqttServer1(this.mqttStringConfig.getMqttServer1());
        mqttConfig.setMqttPort1(this.mqttStringConfig.getMqttPort1());
        mqttConfig.setMqttServer2(this.mqttStringConfig.getMqttServer2());
        mqttConfig.setMqttPort2(this.mqttStringConfig.getMqttPort2());
        mqttConfig.setMqttFallbackServer(this.mqttStringConfig.getMqttFallbackServer());
        mqttConfig.setMqttFallbackPort(this.mqttStringConfig.getMqttFallbackPort());
        mqttConfig.setMqttUsername(this.mqttStringConfig.getMqttUsername());
        mqttConfig.setMqttPassword(this.mqttStringConfig.getMqttPassword());
        mqttConfig.setMqttBaseTopic(this.mqttStringConfig.getMqttBaseTopic());
        mqttConfig.setPublicKeyReceiver(this.mqttStringConfig.getPublicKeyReceiver());
        mqttConfig.setAuthorization(this.mqttStringConfig.getAuthorization());
        mqttConfig.setId(this.mqttStringConfig.getId());
        mqttConfig.setPublicKey(this.mqttStringConfig.getPublicKey());
        mqttConfig.setPrivateKey(this.mqttStringConfig.getPrivateKey());
        return mqttConfig;
    }

    public String getZipPassword() {
        return this.mqttStringConfig.getZipPassword();
    }
}

