/*
 * Decompiled with CFR 0.152.
 */
package de.alamos.ioespa.services.ioprint;

import de.alamos.ioespa.helper.LoggerHelper;
import java.io.IOException;
import lombok.Generated;
import okhttp3.Call;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;

public class WebHookTask
implements Runnable {
    private final Logger logger = LoggerHelper.getLogger(this.getClass());
    private String webHook;
    private final OkHttpClient client;

    @Override
    public void run() {
        this.webHook = this.webHook.trim();
        this.logger.info("Calling WebHook {}...", (Object)this.webHook);
        Request request = new Request.Builder().url(this.webHook).build();
        Call call = this.client.newCall(request);
        try (Response response = call.execute();){
            if (response.isSuccessful()) {
                this.logger.info("Call to {} successfull!", (Object)this.webHook);
            } else {
                this.logger.warn("WebHook {} failed: {}", (Object)this.webHook, (Object)response.code());
            }
        }
        catch (IOException e) {
            this.logger.warn(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    @Generated
    public WebHookTask(String webHook, OkHttpClient client) {
        this.webHook = webHook;
        this.client = client;
    }
}

