/*
 * Decompiled with CFR 0.152.
 */
package de.alamos.ioespa.services.ioespa;

import de.alamos.ioespa.IOEspaApplication;
import de.alamos.ioespa.helper.LoggerHelper;
import de.alamos.ioespa.services.ioespa.EspaControlService;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;

@Service
@Profile(value={"espa"})
public class ESPAHeartbeatAnalyzerService {
    public static final int HEARTBEAT_IN_S = 30;
    private final EspaControlService espaControlService;
    private final Logger logger = LoggerHelper.getLogger(this.getClass());
    private ScheduledExecutorService executorService;
    private final Set<String> hadAtLeastOneHeartbeat = new HashSet();

    @Autowired
    @Lazy
    public ESPAHeartbeatAnalyzerService(EspaControlService espaControlService) {
        this.espaControlService = espaControlService;
    }

    public void startHeartbeatAnalyzer() {
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
        this.executorService = Executors.newScheduledThreadPool(1);
        this.hadAtLeastOneHeartbeat.clear();
        this.logger.info("Start heartbeat analyzer every {} seconds...", (Object)30);
        this.executorService.scheduleAtFixedRate(() -> this.checkHeartbeat(), 30L, 30L, TimeUnit.SECONDS);
    }

    private void checkHeartbeat() {
        List inputs = this.espaControlService.getInputs();
        this.logger.debug("Check last heartbeat for {} inputs...", (Object)inputs.size());
        inputs.forEach(input -> {
            String name = input.getPort().getName();
            boolean hadHeartbeat = this.hadAtLeastOneHeartbeat.contains(name);
            this.logger.debug("hadAtLeastOneHeartbeat for {} = {}", (Object)name, (Object)hadHeartbeat);
            if (!hadHeartbeat) {
                if (input.hasEspaHeartbeat()) {
                    this.hadAtLeastOneHeartbeat.add(name);
                    this.logger.info("Port {} finally has heartbeat (total={})!", (Object)name, (Object)this.hadAtLeastOneHeartbeat.size());
                } else {
                    this.logger.debug("Port {} does not yet have any heartbeat!", (Object)name);
                }
            } else if (input.hasEspaHeartbeat()) {
                this.logger.debug("Port {} still has heartbeat! Nothing to do", (Object)name);
            } else {
                this.logger.error("Port {} has no heartbeat anymore. Last heartbeat {}", (Object)name, (Object)input.getLastHeartbeat());
                this.logger.error("Restart IOespa!!");
                IOEspaApplication.restart();
            }
        });
    }
}

