/*
 * Decompiled with CFR 0.152.
 */
package de.alamos.ioespa.services;

import de.alamos.ioespa.data.FileInfo;
import de.alamos.ioespa.data.FolderInfo;
import de.alamos.ioespa.data.printing.FileSavedInfo;
import de.alamos.ioespa.helper.LoggerHelper;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.UserDefinedFileAttributeView;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public final class FileService {
    private static final String ATTRIBUTE_EXTERNAL_ID = "EXTERNAL_ID";
    private final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd.MM.yy HH:mm:ss");
    public static final String FILES_FOLDER = "config/pdfs/";
    private final Logger logger = LoggerHelper.getLogger(this.getClass());

    @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"})
    public FileSavedInfo save(String id, byte[] pdf, Optional<String> externalId, ZonedDateTime timestamp, Long numberSavedFiles) {
        FileSavedInfo fileSavedInfo;
        String filePath = "config/pdfs/" + id + "_" + timestamp.toEpochSecond() + ".pdf";
        this.logger.debug("Saving file into {}", (Object)filePath);
        File file = this.createFile(filePath);
        if (file == null) {
            return FileSavedInfo.builder().saved(false).build();
        }
        FileOutputStream fos = new FileOutputStream(file);
        try {
            fos.write(pdf);
            this.logger.info("PDF File Saved {}", (Object)file.getName());
            this.deleteOldFile(numberSavedFiles);
            externalId.ifPresent(externalIdValue -> {
                Path path = file.toPath();
                UserDefinedFileAttributeView fileAttributes = Files.getFileAttributeView(path, UserDefinedFileAttributeView.class, new LinkOption[0]);
                try {
                    fileAttributes.write("EXTERNAL_ID", Charset.defaultCharset().encode((String)externalIdValue));
                }
                catch (IOException e) {
                    this.logger.error("Could not write externalId attribute to file {}", (Object)file.getName(), (Object)e);
                }
            });
            fileSavedInfo = FileSavedInfo.builder().saved(true).file(file).build();
        }
        catch (Throwable throwable) {
            try {
                try {
                    fos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
                this.logger.error("PDF File Save FAILED  {}", (Object)file.getName(), (Object)e);
                return FileSavedInfo.builder().saved(false).build();
            }
        }
        fos.close();
        return fileSavedInfo;
    }

    public File createFile(String filePath) {
        File file = new File(filePath);
        try {
            boolean createdDir = file.getParentFile().mkdirs();
            this.logger.debug("{} created: {}", (Object)file.getParentFile().getAbsolutePath(), (Object)createdDir);
            if (!file.exists()) {
                boolean created = file.createNewFile();
                this.logger.debug("{} created: {}", (Object)filePath, (Object)created);
            }
        }
        catch (IOException e) {
            this.logger.error("File Creation FAILED  {}", (Object)file.getName(), (Object)e);
            return null;
        }
        return file;
    }

    public void deleteOldFile(Long numberSavedFiles) {
        this.logger.trace("deleteOldFile()");
        File dir = new File("config/pdfs/");
        File[] files = dir.listFiles();
        if (files == null || (long)files.length <= numberSavedFiles) {
            if (files != null) {
                this.logger.info("Number of saved files {} (Maximum: {}). Nothing to delete", (Object)files.length, (Object)numberSavedFiles);
            }
            return;
        }
        this.logger.info("Number of saved files {} (Maximum: {}). Deleting old file.", (Object)files.length, (Object)numberSavedFiles);
        List<File> oldestFiles = Arrays.stream(files).sorted(Comparator.comparingLong(File::lastModified).reversed()).skip(numberSavedFiles).collect(Collectors.toList());
        if (oldestFiles.isEmpty()) {
            this.logger.warn("No oldest files found");
            return;
        }
        oldestFiles.forEach(file -> {
            String fileName = file.getName();
            LocalDateTime lastModification = LocalDateTime.ofInstant(Instant.ofEpochMilli(file.lastModified()), ZoneId.of("Europe/Berlin"));
            LocalDateTime now = LocalDateTime.now();
            Duration duration = Duration.between(lastModification, now);
            this.logger.info("Age of {}: {} ({})", new Object[]{fileName, lastModification.format(this.formatter), FileService.humanReadableFormat((Duration)duration)});
            boolean isDelete = file.delete();
            if (isDelete) {
                this.logger.info("File {} deleted", (Object)fileName);
            } else {
                this.logger.warn("File {} was NOT delete", (Object)fileName);
            }
        });
    }

    public List<FileInfo> getAllPdfFiles() {
        this.logger.trace("getAllPdfFiles()");
        File dir = new File("config/pdfs/");
        Object[] files = dir.listFiles();
        if (ArrayUtils.isEmpty((Object[])files)) {
            this.logger.debug("No files in directory");
            return new ArrayList<FileInfo>();
        }
        if (files == null) {
            return new ArrayList<FileInfo>();
        }
        return Arrays.stream(files).sorted(Comparator.comparingLong(File::lastModified).reversed()).map(x -> {
            FileInfo fileInfo = new FileInfo(x.getName(), Long.valueOf(x.lastModified()), x.length());
            try {
                UserDefinedFileAttributeView fileAttributes = Files.getFileAttributeView(x.toPath(), UserDefinedFileAttributeView.class, new LinkOption[0]);
                if (fileAttributes.list().contains("EXTERNAL_ID")) {
                    ByteBuffer byteBuffer = ByteBuffer.allocate(fileAttributes.size("EXTERNAL_ID"));
                    fileAttributes.read("EXTERNAL_ID", byteBuffer);
                    fileInfo.setExternalId(Charset.defaultCharset().decode(byteBuffer).toString());
                }
            }
            catch (Exception e) {
                this.logger.warn("File-Attributes for {} could not be read", (Object)x.getName(), (Object)e);
            }
            return fileInfo;
        }).collect(Collectors.toList());
    }

    public Optional<String> readFile(String filePath) {
        try {
            byte[] encoded = Files.readAllBytes(Paths.get(filePath, new String[0]));
            if (ArrayUtils.isEmpty((byte[])encoded)) {
                this.logger.debug("Successfully read {} file, file contains data \"\"", (Object)filePath);
                return Optional.empty();
            }
            String data = new String(encoded, StandardCharsets.UTF_8);
            this.logger.debug("Successfully read {} file, file contains data \"{}\"", (Object)filePath, (Object)data);
            return Optional.of(data);
        }
        catch (IOException e) {
            this.logger.error("Error read {} file", (Object)filePath);
            return Optional.empty();
        }
    }

    @SuppressFBWarnings(value={"DM_DEFAULT_ENCODING"})
    public boolean writeFile(String fileName, String data) {
        boolean bl;
        this.logger.debug("writeFile file={}, data={}", (Object)fileName, (Object)data);
        this.createFile(fileName);
        BufferedWriter writer = new BufferedWriter(new FileWriter(fileName));
        try {
            writer.write(data);
            this.logger.debug("Successfully write {} file, file contains data \"{}\"", (Object)fileName, (Object)data);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                this.logger.error("Error to write file {}", (Object)fileName);
                return false;
            }
        }
        writer.close();
        return bl;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Optional<String> readResourceAsString(String filePath) {
        InputStream inputConfigs = this.getClass().getResourceAsStream(filePath);
        if (inputConfigs == null) {
            this.logger.error("Can not read resource {}", (Object)filePath);
            return Optional.empty();
        }
        try (InputStreamReader isReader = new InputStreamReader(inputConfigs, StandardCharsets.UTF_8);){
            Optional<String> optional;
            try (BufferedReader bufReader = new BufferedReader(isReader);){
                String data = bufReader.lines().collect(Collectors.joining("\n"));
                this.logger.info("Resource {} read successfully", (Object)filePath);
                optional = Optional.of(data);
            }
            return optional;
        }
        catch (IOException e) {
            this.logger.error("Can not read Resource {}", (Object)filePath);
            return Optional.empty();
        }
    }

    public FolderInfo getFolderInfo() {
        File dir = new File("config/pdfs/");
        return new FolderInfo(dir);
    }

    public static String humanReadableFormat(Duration duration) {
        return duration.toString().substring(2).replaceAll("(\\d[HMS])(?!$)", "$1 ").toLowerCase(Locale.ROOT);
    }
}

