/*
 * Decompiled with CFR 0.152.
 */
package de.alamos.ioespa.services.config;

import ch.qos.logback.classic.Level;
import de.alamos.ioespa.data.config.AppConfig;
import de.alamos.ioespa.data.config.ConfigFile;
import de.alamos.ioespa.data.config.ConfigHolder;
import de.alamos.ioespa.data.config.EWizardResponseStatus;
import de.alamos.ioespa.data.config.IOCredentials;
import de.alamos.ioespa.data.config.MqttConfig;
import de.alamos.ioespa.data.config.SetupWizardConfig;
import de.alamos.ioespa.helper.LoggerHelper;
import de.alamos.ioespa.helper.PropertyFileHelper;
import de.alamos.ioespa.helper.mapper.ConfigurationPropertyMapper;
import de.alamos.ioespa.rest.requests.PasswordValidator;
import de.alamos.ioespa.rest.requests.StringConfigRequest;
import de.alamos.ioespa.services.config.IAppConfigChangedListener;
import de.alamos.ioespa.services.encryption.EncryptionService;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Supplier;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class ConfigurationService {
    public static final long DEFAULT_NUMBER_SAVED_FILES = 100L;
    public static final long DEFAULT_CLEANING_INTERVAL = 0L;
    public static final int STEP_12 = 12;
    private final EncryptionService encryptionService;
    private final Logger logger = LoggerHelper.getLogger(this.getClass());
    public static final File PROPERTY_FILE = new File("config/config.properties");
    public static final File APP_PROPERTY_FILE = new File("config/app_config.properties");
    public static final File SETUP_WIZARD_PROPERTY_FILE = new File("config/setup_wizard.properties");
    public static final File CREDENTIALS_FILE = new File("config/credentials.properties");
    private final List<IAppConfigChangedListener> appConfigChangedListeners = new ArrayList();
    @Value(value="${defaultPassword}")
    private String defaultPassword;
    private boolean startingError = false;

    public ConfigurationService(@Lazy EncryptionService encryptionService) {
        this.encryptionService = encryptionService;
    }

    public void registerForConfigChangedEvents(IAppConfigChangedListener listener) {
        if (!this.appConfigChangedListeners.contains(listener)) {
            this.appConfigChangedListeners.add(listener);
        }
    }

    @Bean
    public ConfigHolder loadConfig() {
        MqttConfig config = this.loadConfigFromFile();
        AppConfig appConfig = this.loadAppConfig();
        SetupWizardConfig setupWizardConfig = this.loadAppSetupWizard();
        return new ConfigHolder(config, appConfig, setupWizardConfig);
    }

    public AppConfig loadAppConfig() {
        AppConfig config = new AppConfig();
        Optional opt = PropertyFileHelper.loadProperties((File)APP_PROPERTY_FILE);
        if (opt.isEmpty()) {
            config.setCleaningInterval(Long.valueOf(0L));
            config.setNumberSavedFiles(Long.valueOf(100L));
            config.setUpdatedNow(Boolean.valueOf(false));
            config.setLogLevelStr("DEBUG");
            config.setDuplexOn(Boolean.valueOf(true));
        } else {
            String cleaningInterval = ((Properties)opt.get()).getProperty("cleaningInterval", Long.toString(0L));
            String numberSavedFiles = ((Properties)opt.get()).getProperty("numberSavedFiles", Long.toString(100L));
            config.setWebHook(((Properties)opt.get()).getProperty("webHook", ""));
            config.setSecondPublicKey(((Properties)opt.get()).getProperty("secondPublicKey", ""));
            String logLevel = ((Properties)opt.get()).getProperty("logLevelStr", "DEBUG");
            config.setUpdatedNow(Boolean.valueOf(Boolean.parseBoolean(((Properties)opt.get()).getProperty("updatedNow", "false"))));
            config.setDuplexOn(Boolean.valueOf(Boolean.parseBoolean(((Properties)opt.get()).getProperty("duplexOn", String.valueOf(true)))));
            config.setLogLevelStr(logLevel);
            config.setCleaningInterval(Long.valueOf(Long.parseLong(cleaningInterval)));
            config.setNumberSavedFiles(Long.valueOf(Long.parseLong(numberSavedFiles)));
        }
        this.changeLogLevel(config.getLogLevelStr());
        return config;
    }

    public void changeLogLevel(String logLevelStr) {
        ch.qos.logback.classic.Logger root = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger((String)"ROOT");
        this.logger.info("\u00c4ndere Log-Level auf: {}", (Object)logLevelStr);
        LoggerHelper.updateLogLevel((String)logLevelStr);
        Level level = root.getLevel();
        this.logger.info("Log-Level is: {}", (Object)level);
    }

    public SetupWizardConfig loadAppSetupWizard() {
        SetupWizardConfig config = new SetupWizardConfig();
        Optional opt = PropertyFileHelper.loadProperties((File)SETUP_WIZARD_PROPERTY_FILE);
        if (opt.isPresent()) {
            return SetupWizardConfig.fromProperties((Properties)((Properties)opt.get()));
        }
        config.reset();
        return config;
    }

    @Bean
    public IOCredentials loadCredentials() {
        Optional opt = PropertyFileHelper.loadProperties((File)CREDENTIALS_FILE);
        if (opt.isPresent()) {
            return new IOCredentials((Properties)opt.get());
        }
        this.logger.info("credentials.properties wurde nicht gefunden und wird erzeugt");
        IOCredentials credentials = new IOCredentials(this.defaultPassword);
        PropertyFileHelper.storeInFile((ConfigFile)credentials, (File)CREDENTIALS_FILE);
        return credentials;
    }

    public void saveConfigToFile(MqttConfig mqttConfig) {
        PropertyFileHelper.storeInFile((ConfigFile)mqttConfig, (File)PROPERTY_FILE);
        this.encryptionService.savePrivatePublicKey(mqttConfig.getPrivateKey(), mqttConfig.getPublicKey());
    }

    public void saveZipPassword(String password) {
        if (password == null) {
            return;
        }
        password = password.trim();
        Optional opt = PropertyFileHelper.loadProperties((File)CREDENTIALS_FILE);
        IOCredentials credentials = opt.map(IOCredentials::new).orElseGet((Supplier<IOCredentials>)new IOCredentials(this.defaultPassword));
        credentials.setZipPassword(password);
        PropertyFileHelper.storeInFile((ConfigFile)credentials, (File)CREDENTIALS_FILE);
    }

    public MqttConfig loadConfigFromFile() {
        Optional opt = PropertyFileHelper.loadProperties((File)PROPERTY_FILE);
        return opt.map(ConfigurationPropertyMapper::map).orElse(null);
    }

    public Optional<String> getMacAddress() {
        try {
            this.logger.info("Loading MAC-Address...");
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface network = networkInterfaces.nextElement();
                this.logger.info("Network-Interface: {}", (Object)network.getDisplayName());
                byte[] mac = network.getHardwareAddress();
                if (mac == null) continue;
                CharSequence[] hexadecimal = new String[mac.length];
                for (int i = 0; i < mac.length; ++i) {
                    hexadecimal[i] = String.format("%02X", mac[i]);
                }
                this.logger.debug("MAC-Adresse gefunden");
                return Optional.of(String.join((CharSequence)"", hexadecimal));
            }
        }
        catch (SocketException e) {
            this.logger.error("Es konnte kein Interface mit MAC-Adresse gefunden werden", (Throwable)e);
            return Optional.empty();
        }
        this.logger.error("Es konnte kein Interface mit MAC-Adresse gefunden werden");
        return Optional.empty();
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
    public void resetToFactoryDefaults() {
        SETUP_WIZARD_PROPERTY_FILE.delete();
        PROPERTY_FILE.delete();
        CREDENTIALS_FILE.delete();
        StringConfigRequest request = new StringConfigRequest();
        request.setDuplexOn(true);
        request.setCleaningInterval(Long.valueOf(0L));
        request.setLogLevelStr("DEBUG");
        request.setNumberSavedFiles(Long.valueOf(100L));
        this.updateAppConfig(request);
    }

    public void updateAppConfig(StringConfigRequest configRequest) {
        AppConfig appConfig = new AppConfig();
        appConfig.setNumberSavedFiles(configRequest.getNumberSavedFiles());
        appConfig.setCleaningInterval(configRequest.getCleaningInterval());
        appConfig.setLogLevelStr(configRequest.getLogLevelStr());
        appConfig.setDuplexOn(Boolean.valueOf(configRequest.isDuplexOn()));
        appConfig.setSecondPublicKey(configRequest.getSecondPublicKey());
        this.changeLogLevel(configRequest.getLogLevelStr());
        appConfig.setWebHook(configRequest.getWebHook());
        PropertyFileHelper.storeInFile((ConfigFile)appConfig, (File)APP_PROPERTY_FILE);
        this.appConfigChangedListeners.forEach(listener -> listener.appConfigChanged(appConfig));
    }

    public void updateAppSetupWizardLocalPrinting(boolean localPrintingOk, String message, int nextStep) {
        SetupWizardConfig setupWizardConfig = this.loadAppSetupWizard();
        setupWizardConfig.setLocalPrintingOk(localPrintingOk);
        setupWizardConfig.setLocalPrintingMessage(message);
        setupWizardConfig.setStep(nextStep);
        PropertyFileHelper.storeInFile((ConfigFile)setupWizardConfig, (File)SETUP_WIZARD_PROPERTY_FILE);
    }

    public void updateAppSetupWizardMqtt(Boolean mqttOk, String message, int nextStep) {
        SetupWizardConfig setupWizardConfig = this.loadAppSetupWizard();
        setupWizardConfig.setMqttOk(mqttOk.booleanValue());
        setupWizardConfig.setMqttMessage(message);
        setupWizardConfig.setStep(nextStep);
        PropertyFileHelper.storeInFile((ConfigFile)setupWizardConfig, (File)SETUP_WIZARD_PROPERTY_FILE);
    }

    public void updateAppSetupWizardMqtt(Boolean mqttOk, String message) {
        SetupWizardConfig setupWizardConfig = this.loadAppSetupWizard();
        setupWizardConfig.setMqttOk(mqttOk.booleanValue());
        setupWizardConfig.setMqttMessage(message);
        PropertyFileHelper.storeInFile((ConfigFile)setupWizardConfig, (File)SETUP_WIZARD_PROPERTY_FILE);
    }

    public void updateAppSetupWizardFe2Printing(Long time, Boolean fe2Printing, String message, int nextStep) {
        SetupWizardConfig setupWizardConfig = this.loadAppSetupWizard();
        setupWizardConfig.setFe2PrintingOk(fe2Printing.booleanValue());
        setupWizardConfig.setFe2PrintingMessage(message);
        setupWizardConfig.setFe2PrintingAlarmSendingTime(time);
        setupWizardConfig.setStep(nextStep);
        PropertyFileHelper.storeInFile((ConfigFile)setupWizardConfig, (File)SETUP_WIZARD_PROPERTY_FILE);
    }

    public void updateAppSetupWizardConfiguration(Boolean configurationOk, String message, int nextStep) {
        SetupWizardConfig setupWizardConfig = this.loadAppSetupWizard();
        setupWizardConfig.setConfigurationOk(configurationOk.booleanValue());
        setupWizardConfig.setConfigurationMessage(message);
        setupWizardConfig.setStep(nextStep);
        PropertyFileHelper.storeInFile((ConfigFile)setupWizardConfig, (File)SETUP_WIZARD_PROPERTY_FILE);
    }

    public void updateAppSetupWizardPassword(Boolean passwordOk, String message, int nextStep) {
        SetupWizardConfig setupWizardConfig = this.loadAppSetupWizard();
        setupWizardConfig.setPasswordOk(passwordOk.booleanValue());
        setupWizardConfig.setPasswordMessage(message);
        setupWizardConfig.setStep(nextStep);
        PropertyFileHelper.storeInFile((ConfigFile)setupWizardConfig, (File)SETUP_WIZARD_PROPERTY_FILE);
    }

    public void updateAppSetupWizardStep(int nextStep) {
        SetupWizardConfig setupWizardConfig = this.loadAppSetupWizard();
        setupWizardConfig.setStep(nextStep);
        PropertyFileHelper.storeInFile((ConfigFile)setupWizardConfig, (File)SETUP_WIZARD_PROPERTY_FILE);
    }

    public void updateAppSetupWizardFinish() {
        SetupWizardConfig setupWizardConfig = this.loadAppSetupWizard();
        setupWizardConfig.setStep(12);
        setupWizardConfig.setFinish(true);
        this.updateLogsWizardFinish();
        PropertyFileHelper.storeInFile((ConfigFile)setupWizardConfig, (File)SETUP_WIZARD_PROPERTY_FILE);
    }

    public void updateLogsWizardFinish() {
        AppConfig appConfig = this.loadAppConfig();
        appConfig.setLogLevelStr("INFO");
        this.changeLogLevel("INFO");
        PropertyFileHelper.storeInFile((ConfigFile)appConfig, (File)APP_PROPERTY_FILE);
    }

    public void updateAppSetupWizardFe2PrintingAlarm(String error, EWizardResponseStatus parsed, EWizardResponseStatus printed) {
        SetupWizardConfig setupWizardConfig = this.loadAppSetupWizard();
        setupWizardConfig.setFe2PrintingAlarmError(error);
        setupWizardConfig.setFe2PrintingAlarmParsed(parsed.name());
        setupWizardConfig.setFe2PrintingAlarmPrinting(printed.name());
        PropertyFileHelper.storeInFile((ConfigFile)setupWizardConfig, (File)SETUP_WIZARD_PROPERTY_FILE);
    }

    public void updateAppSetupWizardFe2PrintingAlarmReceived(String error, EWizardResponseStatus received) {
        SetupWizardConfig setupWizardConfig = this.loadAppSetupWizard();
        setupWizardConfig.setFe2PrintingAlarmError(error);
        setupWizardConfig.setFe2PrintingAlarmReceived(received.name());
        PropertyFileHelper.storeInFile((ConfigFile)setupWizardConfig, (File)SETUP_WIZARD_PROPERTY_FILE);
    }

    public void updateAppSetupWizardFe2PrintingAlarmReceived() {
        SetupWizardConfig setupWizardConfig = this.loadAppSetupWizard();
        setupWizardConfig.setFe2PrintingAlarmReceived(EWizardResponseStatus.Ok.name());
        PropertyFileHelper.storeInFile((ConfigFile)setupWizardConfig, (File)SETUP_WIZARD_PROPERTY_FILE);
    }

    public void updateAppSetupWizardPassword(PasswordValidator validatePass, int step) {
        SetupWizardConfig setupWizardConfig = this.loadAppSetupWizard();
        setupWizardConfig.setPasswordOk(validatePass.isValid());
        setupWizardConfig.setPasswordMessage(setupWizardConfig.isPasswordOk() ? "Passwort erfolgreich ge\u00e4ndert" : "Falsches Passwort");
        setupWizardConfig.setPassHasCapital(validatePass.isHasCapital());
        setupWizardConfig.setPassHasDigit(validatePass.isHasDigit());
        setupWizardConfig.setPassHasLowerCase(validatePass.isHasLowerCase());
        setupWizardConfig.setPassLengthOk(validatePass.isLength());
        setupWizardConfig.setPassNotEmpty(validatePass.isNotEmpty());
        setupWizardConfig.setPassEquals(validatePass.isPassEquals());
        setupWizardConfig.setStep(step);
        PropertyFileHelper.storeInFile((ConfigFile)setupWizardConfig, (File)SETUP_WIZARD_PROPERTY_FILE);
    }

    public void updateAppSetupWizardCleanFe2Printing() {
        SetupWizardConfig setupWizardConfig = this.loadAppSetupWizard();
        setupWizardConfig.setFe2PrintingAlarmError("");
        setupWizardConfig.setFe2PrintingOk(false);
        setupWizardConfig.setFe2PrintingMessage("");
        setupWizardConfig.setFe2PrintingAlarmReceived(EWizardResponseStatus.Unknown.name());
        setupWizardConfig.setFe2PrintingAlarmParsed(EWizardResponseStatus.Unknown.name());
        setupWizardConfig.setFe2PrintingAlarmPrinting(EWizardResponseStatus.Unknown.name());
        setupWizardConfig.setFe2PrintingAlarmSendingTime(Long.valueOf(0L));
        PropertyFileHelper.storeInFile((ConfigFile)setupWizardConfig, (File)SETUP_WIZARD_PROPERTY_FILE);
    }

    public void updatingStarted(boolean updatingStarted) {
        AppConfig appConfig = this.loadAppConfig();
        appConfig.setUpdatedNow(Boolean.valueOf(updatingStarted));
        this.changeLogLevel(appConfig.getLogLevelStr());
        PropertyFileHelper.storeInFile((ConfigFile)appConfig, (File)APP_PROPERTY_FILE);
    }

    @Generated
    public void setStartingError(boolean startingError) {
        this.startingError = startingError;
    }

    @Generated
    public boolean isStartingError() {
        return this.startingError;
    }
}

