/*
 * Decompiled with CFR 0.152.
 */
package de.alamos.ioespa.rest.controller;

import de.alamos.ioespa.helper.LoggerHelper;
import de.alamos.ioespa.services.UpdatingService;
import org.slf4j.Logger;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
public class UpdatingController {
    private final Logger logger = LoggerHelper.getLogger(this.getClass());
    private final UpdatingService service;

    public UpdatingController(UpdatingService service) {
        this.service = service;
    }

    @GetMapping(value={"/update"})
    public String update(RedirectAttributes redirAttrs, @RequestParam(name="folder") String folder) {
        this.logger.debug("Start Updating /update?folder={}", (Object)folder);
        folder = folder.trim();
        if (!StringUtils.hasLength((String)folder)) {
            redirAttrs.addFlashAttribute("error", (Object)"Update-Code darf nicht leer sein");
            return "redirect:/remote";
        }
        if (this.service.update(folder)) {
            redirAttrs.addFlashAttribute("isRebootNeeded", (Object)true);
            redirAttrs.addFlashAttribute("success", (Object)"Das Update startet in k\u00fcrze automatisch. IOprint wird anschlie\u00dfend neu gestartet.");
        } else {
            redirAttrs.addFlashAttribute("error", (Object)"Fehler beim schreiben der Update Datei");
        }
        return "redirect:/remote";
    }
}

