/*
 * Decompiled with CFR 0.152.
 */
package de.alamos.ioespa.data.config;

import de.alamos.ioespa.data.config.IOCredentials;
import de.alamos.ioespa.data.config.PasswordEncryptor;
import java.util.ArrayList;
import java.util.Arrays;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.provisioning.InMemoryUserDetailsManager;
import org.springframework.security.web.SecurityFilterChain;

@Configuration
@EnableWebSecurity
public class ApplicationSecurityConfiguration {
    private final IOCredentials credentials;
    private final PasswordEncryptor passwordEncryptor;

    public ApplicationSecurityConfiguration(IOCredentials credentials, PasswordEncryptor passwordEncryptor) {
        this.credentials = credentials;
        this.passwordEncryptor = passwordEncryptor;
    }

    @Bean
    protected SecurityFilterChain configure(HttpSecurity http) throws Exception {
        http.csrf(AbstractHttpConfigurer::disable).formLogin(form -> ((FormLoginConfigurer)((FormLoginConfigurer)form.loginPage("/login").permitAll()).defaultSuccessUrl("/status", true)).failureUrl("/status?error=Nicht autorisiert")).logout(logout -> logout.logoutSuccessUrl("/status")).authorizeHttpRequests(auth -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)auth.requestMatchers(new String[]{"/espa", "/restart", "/mqtt", "/configString", "/logs", "/http", "/files/**", "/password", "/update", "/remote", "/remote/**", "/reinstallPrinters", "/clearAllJobs/**", "/memory"})).authenticated().requestMatchers(new String[]{"/**"})).permitAll()).httpBasic(Customizer.withDefaults());
        return (SecurityFilterChain)http.build();
    }

    @Bean
    public UserDetailsService userDetailsService() {
        ArrayList<UserDetails> users = new ArrayList<UserDetails>();
        users.add(User.withUsername((String)"admin").passwordEncoder(arg_0 -> ((PasswordEncryptor)this.passwordEncryptor).encode(arg_0)).password(Arrays.toString(this.credentials.getSharedSecret())).roles(new String[]{"ADMIN"}).build());
        return new InMemoryUserDetailsManager(users);
    }
}

