/*
 * Decompiled with CFR 0.152.
 */
package de.alamos.ioespa;

import de.alamos.ioespa.helper.LoggerHelper;
import de.alamos.ioespa.helper.exceptions.GenericException;
import de.alamos.ioespa.services.StarterService;
import de.alamos.ioespa.services.ioespa.EspaControlService;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.retry.annotation.EnableRetry;
import org.springframework.scheduling.annotation.EnableScheduling;

@SpringBootApplication
@EnableScheduling
@EnableRetry
public class IOEspaApplication {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IOEspaApplication.class);
    private static final Logger LOGGER = LoggerHelper.getLogger(IOEspaApplication.class);
    private static ConfigurableApplicationContext applicationContext;

    public static void main(String[] args) throws GenericException {
        Thread.currentThread().setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new /* Unavailable Anonymous Inner Class!! */);
        LOGGER.debug("Starting main...");
        try {
            applicationContext = SpringApplication.run(IOEspaApplication.class, (String[])args);
            LOGGER.debug("applicationContext: {}", (Object)applicationContext);
            ((StarterService)applicationContext.getBean(StarterService.class)).init(args);
        }
        catch (Exception e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            System.exit(1);
        }
    }

    @SuppressFBWarnings(value={"MS_EXPOSE_REP"})
    public static ApplicationContext getApplicationContext() {
        return applicationContext;
    }

    public static void restart() {
        ApplicationArguments args = (ApplicationArguments)applicationContext.getBean(ApplicationArguments.class);
        Thread thread = new Thread(() -> {
            if (applicationContext.containsBean("espaControlService")) {
                ((EspaControlService)applicationContext.getBean(EspaControlService.class)).stop();
            }
            applicationContext.close();
            applicationContext = SpringApplication.run(IOEspaApplication.class, (String[])args.getSourceArgs());
            try {
                ((StarterService)applicationContext.getBean(StarterService.class)).init();
            }
            catch (GenericException e) {
                log.error(e.getLocalizedMessage(), (Throwable)e);
            }
        });
        thread.setDaemon(false);
        thread.start();
    }
}

