/*
 * Decompiled with CFR 0.152.
 */
package de.alamos.ioespa.services.ioprint;

import de.alamos.ioespa.IOEspaApplication;
import de.alamos.ioespa.data.config.ConfigHolder;
import de.alamos.ioespa.data.config.MqttConfig;
import de.alamos.ioespa.helper.LoggerHelper;
import de.alamos.ioespa.helper.exceptions.GenericException;
import de.alamos.ioespa.services.HeartbeatService;
import de.alamos.ioespa.services.MqttService;
import de.alamos.ioespa.services.StarterService;
import de.alamos.ioespa.services.config.ConfigurationService;
import de.alamos.ioespa.services.ioprint.PrinterService;
import de.alamos.ioespa.services.ioprint.TestService;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import net.sf.jasperreports.engine.JRException;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Profile;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
@Profile(value={"print"})
public class StarterServicePrint
implements StarterService {
    private final MqttConfig config;
    private final ConfigurationService configurationService;
    private final PrinterService printerService;
    private final TestService testService;
    private final MqttService mqttService;
    public static final int CHECK_MQTT_SLEEP = 30;
    private final Logger logger = LoggerHelper.getLogger(this.getClass());
    @Value(value="${ioPrintServiceFileTemplateResource}")
    private String ioPrintServiceFileTemplateResource;
    @Value(value="${ioPrintServicePath}")
    private String ioPrintServicePath;
    public static final int WAIT_REBOOT = 60;

    @Autowired
    public StarterServicePrint(ConfigHolder configHolder, ConfigurationService configurationService, PrinterService printerService, TestService testService, MqttService mqttService) {
        this.config = configHolder.getMqttConfig();
        this.configurationService = configurationService;
        this.printerService = printerService;
        this.testService = testService;
        this.mqttService = mqttService;
    }

    public void init() throws GenericException {
        this.init(null);
    }

    public void init(String[] args) throws GenericException {
        if (args != null && args.length > 0) {
            this.logger.info("Started args {}", (Object)String.join((CharSequence)", ", args));
            this.configurationService.setStartingError(true);
        }
        this.configurationService.updatingStarted(false);
        this.initializeAsync();
    }

    @Async(value="taskExecutor")
    public void initializeAsync() {
        try {
            this.initializePrinters();
            this.printTestPageIfMqttNotConnectedOrRestartCups();
            if (this.config == null) {
                this.logger.warn("Keine Konfiguration gefunden, Anwendung wird nicht vollst\u00e4ndig gestartet, bitte in Weboberfl\u00e4che Konfiguration hinterlegen");
                return;
            }
            HeartbeatService heartbeatService = this.getHeartbeatService();
            if (heartbeatService != null) {
                heartbeatService.scheduleHeartbeat();
            } else {
                this.logger.warn("HeartbeatService not available, skipping heartbeat initialization");
            }
        }
        catch (Exception e) {
            this.logger.error("Initialization failed", (Throwable)e);
        }
    }

    private void initializePrinters() {
        this.printerService.restartCups();
        if (this.printerService.getPrinterStatusList().isEmpty()) {
            this.printerService.removeAllPrinters();
            this.printerService.createPrinter();
        }
    }

    private void printTestPageIfMqttNotConnectedOrRestartCups() {
        try {
            TimeUnit.SECONDS.sleep(30L);
        }
        catch (InterruptedException e) {
            this.logger.error(e.getLocalizedMessage(), (Throwable)e);
            return;
        }
        if (this.config == null || !this.mqttService.isConnected()) {
            this.logger.info("MqttService is not connected. Try to print test page with Network info");
            try {
                File testPdf = this.testService.getTestPdf(true);
                this.logger.debug("Test Pdf successfully created");
                this.printerService.print(testPdf, 1);
            }
            catch (IOException | JRException e) {
                this.logger.error("Error creating test page.", e);
            }
            catch (Exception e) {
                this.logger.error("Error printing test page.", (Throwable)e);
            }
        } else {
            this.printerService.restartCups();
        }
    }

    private HeartbeatService getHeartbeatService() {
        try {
            if (IOEspaApplication.getApplicationContext() != null) {
                return (HeartbeatService)IOEspaApplication.getApplicationContext().getBean(HeartbeatService.class);
            }
        }
        catch (Exception e) {
            this.logger.warn("Cannot get HeartbeatService, context may be shutting down: {}", (Object)e.getMessage());
        }
        return null;
    }
}

