/*
 * Decompiled with CFR 0.152.
 */
package de.alamos.ioespa.services.ioprint;

import de.alamos.ioespa.helper.ExecuteCommandHelper;
import de.alamos.ioespa.helper.LoggerHelper;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

@Component
@Profile(value={"print"})
@SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"})
public class PrinterRulesService {
    public static final int DEVICE_INDX_4 = 4;
    public static final int DEVICE_INDX_1 = 1;
    public static final int DEVICE_INDX_5 = 5;
    private final ExecuteCommandHelper commandHelper;
    private final Logger logger = LoggerHelper.getLogger(this.getClass());

    public PrinterRulesService(ExecuteCommandHelper commandHelper) {
        this.commandHelper = commandHelper;
    }

    public void createPrinterRules() {
        this.logger.debug("createPrinterRules()");
        ExecuteCommandHelper.setRestartingServicesDone((boolean)false);
        try {
            Optional answer = this.commandHelper.getUsbInfo();
            if (answer.isEmpty()) {
                this.logger.debug("USB rules were not created. Failed to find devices");
                return;
            }
            String[] split = ((String)answer.get()).split("\n");
            List rules = Arrays.stream(split).map(arg_0 -> this.createRule(arg_0)).collect(Collectors.toList());
            this.logger.debug("create rules: {}", (Object)String.join((CharSequence)"; ", rules));
            String printerRules = "/etc/udev/rules.d/51-printer.rules";
            this.saveIntoFile(printerRules, rules);
            this.reloadServices();
        }
        catch (Exception e) {
            this.logger.error("Error creating usb rules", (Throwable)e);
        }
        ExecuteCommandHelper.setRestartingServicesDone((boolean)true);
    }

    private void reloadServices() throws IOException {
        this.commandHelper.reloadRules();
        this.logger.debug("Reload Rules successfully");
        this.commandHelper.restartUdev();
        this.logger.debug("Restart Udev successfully");
        this.commandHelper.reloadRules();
        this.logger.debug("Reload Rules successfully");
        this.commandHelper.restartUdev();
        this.logger.debug("Restart Udev successfully");
        this.commandHelper.restartCups();
        this.logger.debug("Restart Cups successfully");
    }

    private String createRule(String deviceInfo) {
        int idxId = deviceInfo.indexOf("ID");
        int idxSeparator = deviceInfo.indexOf(":", idxId);
        String device = deviceInfo.substring(idxSeparator - 4, idxSeparator);
        String model = deviceInfo.substring(idxSeparator + 1, idxSeparator + 5);
        String printerRulesTmp = "SYSTEM==\"usb\", ATTRS{isVendor}==\"%s\", ATTRS{isProduct}==\"%s\", MODE:=\"774\", GROUP:=\"lp\"";
        return String.format(printerRulesTmp, device, model);
    }

    private File createFile(String filePath) {
        File file = new File(filePath);
        try {
            boolean dirCreated = file.getParentFile().mkdirs();
            this.logger.debug("{} dirCreated: {}", (Object)file.getParentFile(), (Object)dirCreated);
            if (!file.exists()) {
                boolean created = file.createNewFile();
                this.logger.debug("{} created: {}", (Object)filePath, (Object)created);
            }
        }
        catch (IOException e) {
            this.logger.error("File Creation FAILED  {}", (Object)file.getName(), (Object)e);
            return null;
        }
        return file;
    }

    @SuppressFBWarnings(value={"DM_DEFAULT_ENCODING"})
    private void saveIntoFile(String filePath, List<String> data) {
        this.logger.debug("saveIntoFile() file {}, listSize {}", (Object)filePath, data != null ? Integer.valueOf(data.size()) : "null");
        File file = this.createFile(filePath);
        if (file == null || data == null) {
            return;
        }
        try (FileOutputStream fos = new FileOutputStream(file);
             PrintWriter p = new PrintWriter(fos);){
            data.forEach(x -> {
                p.write((String)x);
                p.write("\n");
            });
            this.logger.info("File Saved {}, size={}", (Object)file.getName(), (Object)file.length());
        }
        catch (Exception e) {
            this.logger.error("Could not save into file", (Throwable)e);
            this.logger.error("File Save FAILED  {}", (Object)file.getName(), (Object)e);
        }
    }
}

