/*
 * Decompiled with CFR 0.152.
 */
package de.alamos.ioespa.services;

import de.alamos.ioespa.IOEspaApplication;
import de.alamos.ioespa.data.config.ConfigHolder;
import de.alamos.ioespa.helper.LoggerHelper;
import de.alamos.ioespa.services.LedService;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.net.InetAddress;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.net.ntp.NTPUDPClient;
import org.apache.commons.net.ntp.TimeInfo;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
public class TimeService {
    private final long startTimestamp = System.currentTimeMillis();
    private final Logger logger = LoggerHelper.getLogger(this.getClass());
    private long offset = 0L;
    private long lastSync;
    private boolean isSynced;
    private final ConfigHolder configHolder;
    public static final String DEFAULT_NTP = "pool.ntp.org";

    public TimeService(@Autowired ConfigHolder configHolder) {
        this.configHolder = configHolder;
    }

    @Scheduled(fixedRate=240L, initialDelay=1L, timeUnit=TimeUnit.MINUTES)
    public void periodicallySyncTime() {
        this.logger.trace("Starte Zeitsynchronisierung");
        this.syncTime();
        ((LedService)IOEspaApplication.getApplicationContext().getBean(LedService.class)).setNtpLed(this.isSynced);
    }

    @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"})
    private void syncTime() {
        try {
            String ntpServer = this.getNtpServer();
            if (StringUtils.isBlank((CharSequence)ntpServer)) {
                this.logger.warn("Kein NTP-Server hinterlegt. Zeit-Synchronisation nicht m\u00f6glich");
                return;
            }
            NTPUDPClient client = new NTPUDPClient();
            client.open();
            this.logger.info("Synchronisiere Zeit mit {}", (Object)ntpServer);
            InetAddress hostAddr = InetAddress.getByName(ntpServer);
            client.setDefaultTimeout(10000);
            client.setSoTimeout(10000);
            TimeInfo info = client.getTime(hostAddr);
            info.computeDetails();
            Long offsetValue = info.getOffset();
            if (offsetValue == null) {
                this.logger.warn("Offset konnte nicht geladen werden (null)");
                this.offset = 0L;
                this.isSynced = false;
                return;
            }
            client.close();
            this.offset = offsetValue;
            this.logger.trace("Zeit wurde synchronisiert, Offset: {}", (Object)this.offset);
            this.isSynced = true;
            this.lastSync = this.getAdjustedSystemTime();
        }
        catch (Exception e) {
            this.logger.warn("Zeit konnte nicht synchronisiert werden ({})", (Object)e.getLocalizedMessage());
            this.isSynced = false;
            this.offset = 0L;
        }
    }

    public boolean isSynced() {
        return this.isSynced;
    }

    public long getLastSync() {
        return this.lastSync;
    }

    public long getAdjustedSystemTime() {
        return System.currentTimeMillis() + this.offset;
    }

    public String calculateUptime() {
        Duration uptime = Duration.ofMillis(System.currentTimeMillis() - this.startTimestamp);
        if (!uptime.minus(Duration.ofDays(2L)).isNegative()) {
            return String.format("%s days", uptime.toDays());
        }
        if (!uptime.minus(Duration.ofDays(1L)).isNegative()) {
            return String.format("%s day", uptime.toDays());
        }
        if (!uptime.minus(Duration.ofHours(2L)).isNegative()) {
            return String.format("%s hours", uptime.toHours());
        }
        if (!uptime.minus(Duration.ofHours(1L)).isNegative()) {
            return String.format("%s hour", uptime.toHours());
        }
        if (!uptime.minus(Duration.ofMinutes(2L)).isNegative()) {
            return String.format("%s minutes", uptime.toMinutes());
        }
        if (!uptime.minus(Duration.ofMinutes(1L)).isNegative()) {
            return String.format("%s minute", uptime.toMinutes());
        }
        return String.format("%s seconds", uptime.getSeconds());
    }

    public String getNtpServer() {
        String ntp;
        String string = ntp = this.configHolder.getMqttConfig() != null ? this.configHolder.getMqttConfig().getNtp() : DEFAULT_NTP;
        if (StringUtils.isBlank((CharSequence)ntp)) {
            return DEFAULT_NTP;
        }
        return ntp;
    }
}

