/*
 * Decompiled with CFR 0.152.
 */
package de.alamos.ioespa.services.ioprint;

import de.alamos.ioespa.IOEspaApplication;
import de.alamos.ioespa.data.config.ConfigHolder;
import de.alamos.ioespa.data.config.MqttConfig;
import de.alamos.ioespa.helper.ExecuteCommandHelper;
import de.alamos.ioespa.helper.LoggerHelper;
import de.alamos.ioespa.helper.exceptions.GenericException;
import de.alamos.ioespa.services.FileService;
import de.alamos.ioespa.services.HeartbeatService;
import de.alamos.ioespa.services.MqttService;
import de.alamos.ioespa.services.StarterService;
import de.alamos.ioespa.services.config.ConfigurationService;
import de.alamos.ioespa.services.ioprint.PrinterService;
import de.alamos.ioespa.services.ioprint.TestService;
import java.io.File;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import net.sf.jasperreports.engine.JRException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

@Component
@Profile(value={"print"})
public class StarterServicePrint
implements StarterService {
    private final MqttConfig config;
    private final HeartbeatService heartbeatService;
    private final ConfigurationService configurationService;
    private final PrinterService printerService;
    private final TestService testService;
    private final MqttService mqttService;
    private final FileService fileService;
    public static final int CHECK_MQTT_SLEEP = 30;
    private final Logger logger = LoggerHelper.getLogger(this.getClass());
    @Value(value="${ioPrintServiceFileTemplateResource}")
    private String ioPrintServiceFileTemplateResource;
    @Value(value="${ioPrintServicePath}")
    private String ioPrintServicePath;
    public static final int WAIT_REBOOT = 60;

    @Autowired
    public StarterServicePrint(ConfigHolder configHolder, HeartbeatService heartbeatService, ConfigurationService configurationService, PrinterService printerService, TestService testService, MqttService mqttService, FileService fileService) {
        this.config = configHolder.getMqttConfig();
        this.heartbeatService = heartbeatService;
        this.configurationService = configurationService;
        this.printerService = printerService;
        this.testService = testService;
        this.mqttService = mqttService;
        this.fileService = fileService;
    }

    public void init() throws GenericException {
        this.init(null);
    }

    public void init(String[] args) throws GenericException {
        if (args != null && args.length > 0) {
            this.logger.info("Started args {}", (Object)String.join((CharSequence)", ", args));
            this.configurationService.setStartingError(true);
        }
        this.configurationService.updatingStarted(false);
        Optional resourceFile = this.fileService.readResourceAsString(this.ioPrintServiceFileTemplateResource);
        Optional oldFile = this.fileService.readFile(this.ioPrintServicePath);
        if (resourceFile.isPresent() && oldFile.isPresent() && !StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{(CharSequence)resourceFile.get(), (CharSequence)oldFile.get()}) && !((String)resourceFile.get()).equals(oldFile.get())) {
            this.logger.info("Overwriting file {}", (Object)this.ioPrintServicePath);
            this.fileService.writeFile(this.ioPrintServicePath, (String)resourceFile.get());
            this.logger.info("SECOND Reboot IOprint after updating started");
            if (this.getExecuteCommandHelper().systemReboot()) {
                try {
                    TimeUnit.SECONDS.sleep(60L);
                }
                catch (InterruptedException e) {
                    throw new GenericException((Exception)e);
                }
            }
        } else {
            this.logger.info("Overwriting file {} skipped because file {} not exist, empty or identical", (Object)this.ioPrintServicePath, (Object)this.ioPrintServiceFileTemplateResource);
        }
        this.printerService.restartCups();
        if (this.printerService.getPrinterStatusList().isEmpty()) {
            this.printerService.removeAllPrinters();
            this.printerService.createPrinter();
        }
        new Thread(() -> this.printTestPageIfMqttNotConnectedOrRestartCups()).start();
        if (this.config == null) {
            this.logger.warn("Keine Konfiguration gefunden, Anwendung wird nicht vollst\u00e4ndig gestartet, bitte in Weboberfl\u00e4che Konfiguration hinterlegen");
            return;
        }
        this.heartbeatService.scheduleHeartbeat();
    }

    private void printTestPageIfMqttNotConnectedOrRestartCups() {
        try {
            TimeUnit.SECONDS.sleep(30L);
        }
        catch (InterruptedException e) {
            this.logger.error(e.getLocalizedMessage(), (Throwable)e);
            return;
        }
        if (this.config == null || !this.mqttService.isConnected()) {
            this.logger.info("MqttService is not connected. Try to print test page with Network info");
            try {
                File testPdf = this.testService.getTestPdf(true);
                this.logger.debug("Test Pdf successfully created");
                this.printerService.print(testPdf, 1);
            }
            catch (IOException | JRException e) {
                this.logger.error("Error creating test page.", e);
            }
            catch (Exception e) {
                this.logger.error("Error printing test page.", (Throwable)e);
            }
        } else {
            this.printerService.restartCups();
        }
    }

    private ExecuteCommandHelper getExecuteCommandHelper() {
        return (ExecuteCommandHelper)IOEspaApplication.getApplicationContext().getBean(ExecuteCommandHelper.class);
    }
}

