/*
 * Decompiled with CFR 0.152.
 */
package de.alamos.ioespa.services.encryption;

import com.alamos.security.EncryptionController;
import com.alamos.security.exceptions.SignatureException;
import com.alamos.security.interfaces.IBase64EncoderDecoder;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.alamos.firemergency.security.SymmetricEncryptionResult;
import de.alamos.ioespa.data.config.ConfigHolder;
import de.alamos.ioespa.data.config.MqttConfig;
import de.alamos.ioespa.data.mqtt.EncryptedMqttData;
import de.alamos.ioespa.data.mqtt.SignedMqttData;
import de.alamos.ioespa.helper.LoggerHelper;
import de.alamos.ioespa.services.encryption.Base64EncoderDecoder;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileOutputStream;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.RandomStringUtils;
import org.slf4j.Logger;
import org.springframework.stereotype.Component;

@Component
public class EncryptionService {
    public static final String PATH_TO_KEYS = "config/keys";
    public static final int DEFAULT_AMOUNT_OF_CHARS = 5;
    public static final int ASCII_A = 65;
    public static final int ASCII_Z = 90;
    public static final int ASCII_LOWERCASE_A = 97;
    public static final int ASCII_LOWERCASE_Z = 122;
    public static final int ASCII_EXCLEMATION = 33;
    public static final int ASCII_SLASH = 47;
    private final Logger logger = LoggerHelper.getLogger(this.getClass());
    private final MqttConfig config;
    private final EncryptionController encryptionController;
    private final ObjectMapper objectMapper;
    private final Base64EncoderDecoder base64 = new Base64EncoderDecoder();

    @SuppressFBWarnings(value={"CT_CONSTRUCTOR_THROW"})
    public EncryptionService(ConfigHolder configHolder) throws SignatureException {
        this.objectMapper = new ObjectMapper();
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.encryptionController = EncryptionController.getInstance();
        this.encryptionController.init((IBase64EncoderDecoder)this.base64);
        this.config = configHolder.getMqttConfig();
        File file = new File(PATH_TO_KEYS);
        boolean created = file.mkdirs();
        this.logger.debug("{} created: {}", (Object)file.getAbsolutePath(), (Object)created);
        this.encryptionController.initSignature(file);
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE", "REC_CATCH_EXCEPTION"})
    public void savePrivatePublicKey(String privateKeyAsBase64, String publicKeyAsBase64) {
        try {
            File folderForKeys = new File(PATH_TO_KEYS);
            folderForKeys.mkdirs();
            new File("config/keys/public.key").delete();
            new File("config/keys/private.key").delete();
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PublicKey publicKey = keyFactory.generatePublic(new X509EncodedKeySpec(this.base64.decode(publicKeyAsBase64)));
            PrivateKey privateKey = keyFactory.generatePrivate(new PKCS8EncodedKeySpec(this.base64.decode(privateKeyAsBase64)));
            try (FileOutputStream fosPublic = new FileOutputStream("config/keys/public.key");){
                fosPublic.write(publicKey.getEncoded());
                try (FileOutputStream fosPrivate = new FileOutputStream("config/keys/private.key");){
                    fosPrivate.write(privateKey.getEncoded());
                }
            }
        }
        catch (Exception e) {
            this.logger.error("Private/Public Key konnte nicht persistiert werden", (Throwable)e);
        }
    }

    public String encrypt(String message) throws Exception {
        if (this.config == null) {
            this.logger.info("Keine Konfiguration gefunden, Nachricht wird nicht verschl\u00fcsselt");
            return message;
        }
        this.logger.trace("Generiere Passwort");
        String password = this.generatePassword();
        this.logger.trace("Verschl\u00fcssele Nachricht");
        SymmetricEncryptionResult symmetricEncryptionResult = this.encryptionController.encryptSymmetric(password, message);
        this.logger.trace("Verschl\u00fcssele Passwort");
        String encryptedPassword = this.encryptionController.encryptAsymmetric(this.config.getPublicKeyReceiver(), password);
        EncryptedMqttData encryptedMqttData = new EncryptedMqttData(symmetricEncryptionResult, encryptedPassword);
        String json = this.objectMapper.writeValueAsString((Object)encryptedMqttData);
        this.logger.trace("Signiere Paket");
        String signature = this.encryptionController.sign(json);
        return this.objectMapper.writeValueAsString((Object)new SignedMqttData(encryptedMqttData, signature));
    }

    private String generatePassword() {
        int amountOfChars = 5;
        String upperCaseLetters = RandomStringUtils.random((int)amountOfChars, (int)65, (int)90, (boolean)true, (boolean)true);
        String lowerCaseLetters = RandomStringUtils.random((int)amountOfChars, (int)97, (int)122, (boolean)true, (boolean)true);
        String numbers = RandomStringUtils.randomNumeric((int)amountOfChars);
        String specialChar = RandomStringUtils.random((int)amountOfChars, (int)33, (int)47, (boolean)false, (boolean)false);
        String totalChars = RandomStringUtils.randomAlphanumeric((int)amountOfChars);
        String combinedChars = upperCaseLetters.concat(lowerCaseLetters).concat(numbers).concat(specialChar).concat(totalChars);
        List pwdChars = combinedChars.chars().mapToObj(c -> Character.valueOf((char)c)).collect(Collectors.toList());
        Collections.shuffle(pwdChars);
        return pwdChars.stream().collect(StringBuilder::new, StringBuilder::append, StringBuilder::append).toString();
    }
}

