/*
 * Decompiled with CFR 0.152.
 */
package de.alamos.ioespa.rest.responses.ioprint;

import de.alamos.firemergency.ioprint.responses.EIOPrintResponseStatus;
import de.alamos.firemergency.ioprint.responses.EPrinterResponse;
import de.alamos.firemergency.ioprint.responses.IOPrintResponse;
import de.alamos.ioespa.data.printing.JobInfo;
import de.alamos.ioespa.helper.LoggerHelper;
import de.alamos.ioespa.services.ioprint.PrinterService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;

@Service
@Profile(value={"print"})
public class UpdaterPrinterStatusResponse {
    public static final int WAITING_TIME = 1;
    private final List<EPrinterResponse> statusesToUpdate = List.of(EPrinterResponse.In_Queue, EPrinterResponse.Door_Open, EPrinterResponse.Printing, EPrinterResponse.Jammed, EPrinterResponse.Low_Paper, EPrinterResponse.No_Paper, EPrinterResponse.No_Toner);
    private final Logger logger = LoggerHelper.getLogger(this.getClass());
    private final PrinterService printerService;

    public UpdaterPrinterStatusResponse(PrinterService printerService) {
        this.printerService = printerService;
    }

    public IOPrintResponse updateJobStatus(String id, Map<String, JobInfo> printersJobInfo, boolean isSaved) {
        this.logger.trace("Start updateJobStatus id={}, printersJobInfo size={}, isSaved={} ", new Object[]{id, printersJobInfo.size(), isSaved});
        IOPrintResponse response = new IOPrintResponse();
        HashMap updated = new HashMap();
        printersJobInfo.forEach((k, v) -> {
            EPrinterResponse ePrinterResponse;
            EPrinterResponse ePrinterResponse2 = ePrinterResponse = v.getJobName().isPresent() ? this.printerService.askStatusJob(k, (String)v.getJobName().get()) : v.getEPrinterResponse();
            if (ePrinterResponse.equals((Object)EPrinterResponse.Printing) && this.printerService.checkJobTime(k, (String)v.getJobName().get()) > 45L) {
                ePrinterResponse = EPrinterResponse.Has_Problem;
            }
            this.logger.trace("AlarmId={} JOB {} in printer {} has status {}", new Object[]{id, v.getJobName().isPresent() ? v.getJobName().get() : "Unknown", k, ePrinterResponse});
            updated.put(k, ePrinterResponse);
        });
        response.setId(id);
        response.setPrintersResponse(updated);
        response.setStatus(EIOPrintResponseStatus.SUCCESSFUL);
        response.setSaved(isSaved);
        return response;
    }

    public boolean shouldBeUpdated(Map<String, JobInfo> printersJobInfo) {
        return printersJobInfo.values().stream().filter(x -> x.getJobName().isPresent()).anyMatch(x -> this.statusesToUpdate.contains(x.getEPrinterResponse()));
    }
}

