/*
 * Decompiled with CFR 0.152.
 */
package de.alamos.ioespa.services.ioprint;

import com.alamos.security.EncryptionController;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import de.alamos.firemergency.ioprint.requests.AlarmPrintDecrypted;
import de.alamos.firemergency.ioprint.requests.AlarmPrintDecryptedRequest;
import de.alamos.firemergency.ioprint.requests.AlarmPrintEncryptedRequest;
import de.alamos.firemergency.ioprint.responses.EIOPrintResponseStatus;
import de.alamos.firemergency.security.SymmetricEncryptionResult;
import de.alamos.ioespa.data.config.AppConfig;
import de.alamos.ioespa.data.config.ConfigHolder;
import de.alamos.ioespa.data.config.EWizardResponseStatus;
import de.alamos.ioespa.data.config.MqttConfig;
import de.alamos.ioespa.data.config.SetupWizardConfig;
import de.alamos.ioespa.data.printing.FileSavedInfo;
import de.alamos.ioespa.data.printing.IOPrintInfo;
import de.alamos.ioespa.helper.LoggerHelper;
import de.alamos.ioespa.services.FileService;
import de.alamos.ioespa.services.config.ConfigurationService;
import de.alamos.ioespa.services.config.IAppConfigChangedListener;
import de.alamos.ioespa.services.ioprint.PrinterService;
import de.alamos.ioespa.services.ioprint.TrustAllTrustManager;
import de.alamos.ioespa.services.ioprint.WebHookTask;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;

@Service
@Profile(value={"print"})
public class AlarmService
implements IAppConfigChangedListener {
    private final Logger logger = LoggerHelper.getLogger(this.getClass());
    public static final int LIVE_ALARM_PERIOD = 15;
    private final ObjectMapper objectMapper;
    private final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm:ss x");
    private final ExecutorService executorService = Executors.newCachedThreadPool();
    private final OkHttpClient client;
    private final PrinterService printerService;
    private final FileService fileService;
    private final MqttConfig config;
    private AppConfig appConfig;
    private final ConfigurationService configurationService;
    private static final Cache<String, Integer> ALARM_CACHE = Caffeine.newBuilder().expireAfterWrite(1L, TimeUnit.HOURS).build();

    public AlarmService(PrinterService printerService, FileService fileService, ConfigHolder configHolder, ConfigurationService configurationService) {
        this.printerService = printerService;
        this.fileService = fileService;
        this.config = configHolder.getMqttConfig();
        this.appConfig = configHolder.getAppConfig();
        this.configurationService = configurationService;
        this.objectMapper = new ObjectMapper();
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        OkHttpClient.Builder builder = new OkHttpClient.Builder().connectTimeout(30L, TimeUnit.SECONDS).readTimeout(10L, TimeUnit.SECONDS).writeTimeout(10L, TimeUnit.SECONDS).retryOnConnectionFailure(true);
        try {
            TrustManager[] trustAllCerts = new TrustManager[]{new TrustAllTrustManager()};
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, trustAllCerts, new SecureRandom());
            builder.sslSocketFactory(sslContext.getSocketFactory(), (X509TrustManager)trustAllCerts[0]).hostnameVerifier((hostname, session) -> true);
        }
        catch (NoSuchAlgorithmException ex) {
            this.logger.warn("Could not init trust all certificates client (NoSuchAlgorithmException)", (Throwable)ex);
        }
        catch (KeyManagementException ex) {
            this.logger.warn("Could not init trust all certificates client (KeyManagementException)", (Throwable)ex);
        }
        this.client = builder.build();
        this.configurationService.registerForConfigChangedEvents((IAppConfigChangedListener)this);
    }

    private synchronized boolean isDuplicate(byte[] payload, String alarmId) {
        Integer alarmCache = (Integer)ALARM_CACHE.getIfPresent((Object)alarmId);
        int hashCode = Arrays.hashCode(payload);
        ALARM_CACHE.put((Object)alarmId, (Object)hashCode);
        if (alarmCache != null) {
            this.logger.info("message with id {} is duplicate and will be skipped. Messages HashCodes is equal {}", (Object)alarmId, (Object)(hashCode == alarmCache ? 1 : 0));
            return true;
        }
        return false;
    }

    @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"})
    public IOPrintInfo alarm(int id, String alarmId, byte[] payload) {
        ZonedDateTime alarmTime;
        byte[] pdf;
        AlarmPrintDecryptedRequest alarmPrintDecrypted;
        boolean currentAlarmIsProbablyTestPage;
        if (this.isDuplicate(payload, alarmId)) {
            this.logger.trace("Message with alarmId {} Skipped as duplicated", (Object)alarmId);
            return null;
        }
        this.logger.info("New message with alarmId {} is NOT a Duplicate", (Object)alarmId);
        SetupWizardConfig setupWizardConfig = this.configurationService.loadAppSetupWizard();
        boolean bl = currentAlarmIsProbablyTestPage = !setupWizardConfig.isFinish();
        if (currentAlarmIsProbablyTestPage) {
            this.configurationService.updateAppSetupWizardFe2PrintingAlarmReceived();
        }
        IOPrintInfo response = new IOPrintInfo();
        response.setStatus(EIOPrintResponseStatus.SUCCESSFUL);
        response.setId(alarmId);
        if (alarmId == null && currentAlarmIsProbablyTestPage) {
            this.configurationService.updateAppSetupWizardFe2PrintingAlarm("Alarm parsing id error", EWizardResponseStatus.Fail, EWizardResponseStatus.Fail);
        }
        try {
            alarmPrintDecrypted = this.decryptAlarm(payload);
            response.setId(alarmPrintDecrypted.getId());
        }
        catch (IOException e) {
            response.setStatus(EIOPrintResponseStatus.PARSE_ERROR);
            this.logger.error("Alarm parsing error", (Throwable)e);
            if (currentAlarmIsProbablyTestPage) {
                this.configurationService.updateAppSetupWizardFe2PrintingAlarm("Alarm parsing error", EWizardResponseStatus.Fail, EWizardResponseStatus.Fail);
            }
            return response;
        }
        catch (com.alamos.security.exceptions.SignatureException e) {
            response.setStatus(EIOPrintResponseStatus.PUBLIC_KEY_INCORRECT);
            this.logger.error("Alarm public kay error", (Throwable)e);
            if (currentAlarmIsProbablyTestPage) {
                this.configurationService.updateAppSetupWizardFe2PrintingAlarm("Alarm public kay error", EWizardResponseStatus.Fail, EWizardResponseStatus.Fail);
            }
            return response;
        }
        catch (SignatureException e) {
            response.setStatus(EIOPrintResponseStatus.SIGNATURE_INCORRECT);
            this.logger.error("Alarm signature error", (Throwable)e);
            if (currentAlarmIsProbablyTestPage) {
                this.configurationService.updateAppSetupWizardFe2PrintingAlarm("Alarm signature error", EWizardResponseStatus.Fail, EWizardResponseStatus.Fail);
            }
            return response;
        }
        catch (Exception e) {
            response.setStatus(EIOPrintResponseStatus.DECRYPTION_ERROR);
            if (currentAlarmIsProbablyTestPage) {
                this.configurationService.updateAppSetupWizardFe2PrintingAlarm("Alarm decryption error", EWizardResponseStatus.Fail, EWizardResponseStatus.Fail);
            }
            this.logger.error("Alarm decryption error", (Throwable)e);
            return response;
        }
        try {
            pdf = Base64.getDecoder().decode(alarmPrintDecrypted.getAlarmPrint().getPdf());
        }
        catch (Exception e) {
            response.setStatus(EIOPrintResponseStatus.PDF_DAMAGED);
            this.logger.error("Alarm pdf damaged error", (Throwable)e);
            if (currentAlarmIsProbablyTestPage) {
                this.configurationService.updateAppSetupWizardFe2PrintingAlarm("Alarm pdf damaged error", EWizardResponseStatus.Fail, EWizardResponseStatus.Fail);
            }
            return response;
        }
        try {
            alarmTime = ZonedDateTime.parse(alarmPrintDecrypted.getTimestamp(), this.formatter);
        }
        catch (Exception e) {
            response.setStatus(EIOPrintResponseStatus.PARSE_ERROR);
            this.logger.error("Alarm parse Timestamp error", (Throwable)e);
            if (currentAlarmIsProbablyTestPage) {
                this.configurationService.updateAppSetupWizardFe2PrintingAlarm("Alarm parse Timestamp error", EWizardResponseStatus.Fail, EWizardResponseStatus.Fail);
            }
            return response;
        }
        if (ChronoUnit.MINUTES.between(alarmTime, ZonedDateTime.now()) < 15L) {
            this.logger.info("External-ID: {}", (Object)alarmPrintDecrypted.getAlarmPrint().getExternalId());
            FileSavedInfo fileSavedInfo = this.fileService.save(alarmPrintDecrypted.getId(), pdf, Optional.ofNullable(alarmPrintDecrypted.getAlarmPrint().getExternalId()), ZonedDateTime.now(), this.appConfig.getNumberSavedFiles());
            response.setSaved(fileSavedInfo.isSaved());
            if (this.appConfig.hasWebHook() && alarmPrintDecrypted.getAlarmPrint().isWithWebhook()) {
                this.logger.info("Triggering webhook for {}...", (Object)this.appConfig.getWebHook());
                Future<?> future = this.executorService.submit((Runnable)new WebHookTask(this.appConfig.getWebHook(), this.client));
                this.logger.info("Future: {}", (Object)future.hashCode());
            }
            try {
                Map printersJobInfo;
                if (fileSavedInfo.isSaved()) {
                    this.logger.info("Using saved PDF in config folder {} for printing...", (Object)fileSavedInfo.getFile().getAbsolutePath());
                    printersJobInfo = this.printerService.print(fileSavedInfo.getFile(), alarmPrintDecrypted.getAlarmPrint().getCopies());
                } else {
                    this.logger.info("Using PDF in temp folder because saving did not work...");
                    printersJobInfo = this.printerService.print(pdf, alarmPrintDecrypted.getAlarmPrint().getCopies());
                }
                response.setPrintersJobInfo(printersJobInfo);
                if (printersJobInfo != null) {
                    HashMap printersResponse = new HashMap();
                    printersJobInfo.forEach((k, v) -> printersResponse.put(k, v.getEPrinterResponse()));
                    response.setPrintersResponse(printersResponse);
                }
                if (currentAlarmIsProbablyTestPage) {
                    this.configurationService.updateAppSetupWizardFe2PrintingAlarm("", EWizardResponseStatus.Ok, EWizardResponseStatus.Ok);
                }
            }
            catch (Exception e) {
                response.setStatus(EIOPrintResponseStatus.NO_PRINTERS);
                if (currentAlarmIsProbablyTestPage) {
                    this.configurationService.updateAppSetupWizardFe2PrintingAlarm("Alarm no printers error", EWizardResponseStatus.Ok, EWizardResponseStatus.Fail);
                }
                this.logger.error("Alarm no printers error", (Throwable)e);
            }
        } else {
            response.setStatus(EIOPrintResponseStatus.OLD_ALARM);
            if (currentAlarmIsProbablyTestPage) {
                this.configurationService.updateAppSetupWizardFe2PrintingAlarm(String.format("Alarm older then %d minutes", 15), EWizardResponseStatus.Ok, EWizardResponseStatus.Fail);
            }
            this.logger.error("Alarm older then {} minutes", (Object)15);
        }
        this.logger.info("Alarm {} parsed and printed successfully", (Object)id);
        return response;
    }

    private AlarmPrintDecryptedRequest decryptAlarm(byte[] payload) throws Exception {
        String password;
        this.logger.trace("decryptAlarm (byte[] payload)");
        JsonNode jsonNode = this.objectMapper.readTree(payload);
        AlarmPrintEncryptedRequest encryptedRequest = (AlarmPrintEncryptedRequest)this.objectMapper.convertValue((Object)jsonNode, AlarmPrintEncryptedRequest.class);
        this.logger.debug("Payload parse successful");
        EncryptionController encryptionController = EncryptionController.getInstance();
        boolean signatureMatches = encryptionController.verifySignature(encryptedRequest.getEncryptedMessage().getEncryptedMessage(), encryptedRequest.getSignature(), this.config.getPublicKeyReceiver());
        if (!signatureMatches) {
            this.logger.warn("Primary Signature does not match");
            if (this.appConfig.hasSecondPublicKey()) {
                this.logger.info("System has second public key. Verify public key...");
                signatureMatches = encryptionController.verifySignature(encryptedRequest.getEncryptedMessage().getEncryptedMessage(), encryptedRequest.getSignature(), this.appConfig.getSecondPublicKey());
                if (!signatureMatches) {
                    this.logger.warn("Second Signature does not match");
                    throw new SignatureException("No Signature does match");
                }
            } else {
                throw new SignatureException("Signature does not match");
            }
        }
        this.logger.info("Signature matches");
        if (encryptedRequest.isRsa()) {
            this.logger.info("Using asymmetric decryption for password");
            password = encryptionController.decryptAsymmetric(encryptionController.getPrivateKey(), encryptedRequest.getPassword());
        } else {
            this.logger.warn("Using symmetric decryption for password. Update FE2 and IOprint to get asymmetric description!");
            SymmetricEncryptionResult encryptedPass = (SymmetricEncryptionResult)this.objectMapper.convertValue((Object)this.objectMapper.readTree(encryptedRequest.getPassword()), SymmetricEncryptionResult.class);
            this.logger.debug("Using {}....", (Object)encryptionController.getPublicKey());
            password = encryptionController.decryptSymmetric(encryptedPass, encryptionController.getPublicKey());
        }
        this.logger.info("Password decryption successful!");
        String decryptSymmetric = encryptionController.decryptSymmetric(encryptedRequest.getEncryptedMessage(), password);
        this.logger.info("Decryption successful");
        AlarmPrintDecryptedRequest decryptedRequest = new AlarmPrintDecryptedRequest();
        decryptedRequest.setId(encryptedRequest.getId());
        decryptedRequest.setTimestamp(encryptedRequest.getTimestamp());
        decryptedRequest.setAlarmPrint((AlarmPrintDecrypted)this.objectMapper.convertValue((Object)this.objectMapper.readTree(decryptSymmetric), AlarmPrintDecrypted.class));
        this.logger.trace("Alarm parsed and decrypted successfully");
        return decryptedRequest;
    }

    public void appConfigChanged(AppConfig appConfig) {
        this.logger.info("AppConfig has been changed!");
        this.appConfig = appConfig;
    }
}

