/*
 * Decompiled with CFR 0.152.
 */
package de.alamos.ioespa.services;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import de.alamos.firemergency.ioprint.requests.IOPrintUpdate;
import de.alamos.firemergency.ioprint.responses.ERebootingStatus;
import de.alamos.firemergency.ioprint.responses.UpdatingResponse;
import de.alamos.ioespa.helper.LoggerHelper;
import de.alamos.ioespa.services.VersionService;
import de.alamos.ioespa.services.config.ConfigurationService;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class UpdatingService {
    public static final String UPDATE_FILE_PATH = "/opt/io-print/update.txt";
    private final Logger logger = LoggerHelper.getLogger(this.getClass());
    private final VersionService versionService;
    private final ConfigurationService configurationService;
    private static final long LIVE_UPDATE_MSG_PERIOD = 2L;
    private final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm:ss x");
    private static final Cache<String, String> UPDATE_CACHE = Caffeine.newBuilder().expireAfterWrite(1L, TimeUnit.HOURS).build();

    public UpdatingService(VersionService versionService, ConfigurationService configurationService) {
        this.versionService = versionService;
        this.configurationService = configurationService;
    }

    public String getCurrentVersion() {
        return this.versionService.getCurrentVersion();
    }

    public synchronized boolean update(String folder) {
        this.configurationService.updatingStarted(true);
        try {
            this.writeUpdateFile(folder);
        }
        catch (IOException e) {
            this.logger.error("Could not write Update File.", (Throwable)e);
            return false;
        }
        catch (IllegalArgumentException e) {
            this.logger.error(e.getMessage());
            return false;
        }
        return true;
    }

    private void writeUpdateFile(String folder) throws IOException, IllegalArgumentException {
        if (null == folder) {
            throw new IllegalArgumentException("update folder is null");
        }
        Path path = Path.of(UPDATE_FILE_PATH, new String[0]);
        Path parentDir = path.getParent();
        if (parentDir != null && !Files.exists(parentDir, new LinkOption[0])) {
            Files.createDirectories(parentDir, new FileAttribute[0]);
        }
        Files.writeString(path, (CharSequence)folder, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
    }

    public synchronized UpdatingResponse updateIoPrint(IOPrintUpdate ioPrintUpdate) {
        String updateCash = (String)UPDATE_CACHE.getIfPresent((Object)ioPrintUpdate.getUpdatingRequestID());
        UPDATE_CACHE.put((Object)ioPrintUpdate.getUpdatingRequestID(), (Object)ioPrintUpdate.getCode());
        if (updateCash != null) {
            this.logger.info("message with id {} is duplicate and will be skipped. Messages Codes is equal {}", (Object)ioPrintUpdate.getUpdatingRequestID(), (Object)updateCash.equals(ioPrintUpdate.getCode()));
            return null;
        }
        UpdatingResponse response = new UpdatingResponse();
        response.setUpdatingRequestID(ioPrintUpdate.getUpdatingRequestID());
        try {
            ZonedDateTime alarmTime = ZonedDateTime.parse(ioPrintUpdate.getTime(), this.formatter);
            this.logger.debug("UPDATE time is {}, now {}", (Object)alarmTime, (Object)ZonedDateTime.now());
            if (ChronoUnit.MINUTES.between(alarmTime, ZonedDateTime.now()) > 2L) {
                this.logger.error(String.format("Update message older than %d minutes", 2L));
                return null;
            }
        }
        catch (Exception e) {
            response.setNeedsReboot(ERebootingStatus.NOT_NEEDED);
            response.setSuccess(false);
            response.setMessage("Alarm parse Timestamp error");
            response.setCurrentVersion(this.getCurrentVersion());
            this.logger.error("Alarm parse Timestamp error", (Throwable)e);
            return response;
        }
        if (this.update(ioPrintUpdate.getCode())) {
            response.setNeedsReboot(ERebootingStatus.IN_PROGRESS);
            response.setSuccess(true);
            response.setMessage("Update erfolgreich abgeschlossen. Das Ger\u00e4t wird neu gestartet.");
        } else {
            response.setNeedsReboot(ERebootingStatus.NOT_NEEDED);
            response.setSuccess(true);
            response.setMessage("Kein Update erforderlich");
        }
        response.setCode(ioPrintUpdate.getCode());
        response.setCurrentVersion(this.getCurrentVersion());
        return response;
    }
}

