/*
 * Decompiled with CFR 0.152.
 */
package de.alamos.ioespa.services;

import de.alamos.ioespa.helper.LoggerHelper;
import de.alamos.ioespa.rest.responses.status.EAppName;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import org.slf4j.Logger;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

@Service
public class AppInfoService {
    private final Logger logger = LoggerHelper.getLogger(this.getClass());
    private final Environment environment;

    public AppInfoService(Environment environment) {
        this.environment = environment;
    }

    public EAppName getAppName() {
        String[] activeProfiles = this.environment.getActiveProfiles();
        if (Arrays.asList(activeProfiles).contains("espa")) {
            return EAppName.IOEspa;
        }
        if (Arrays.asList(activeProfiles).contains("print")) {
            return EAppName.IOPrint;
        }
        return null;
    }

    public List<String> getMacAddresses() {
        ArrayList<String> macs = new ArrayList<String>();
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface ni = networkInterfaces.nextElement();
                byte[] hardwareAddress = ni.getHardwareAddress();
                if (hardwareAddress == null) continue;
                CharSequence[] hexadecimalFormat = new String[hardwareAddress.length];
                for (int i = 0; i < hardwareAddress.length; ++i) {
                    hexadecimalFormat[i] = String.format("%02X", hardwareAddress[i]);
                }
                macs.add(String.join((CharSequence)"-", hexadecimalFormat));
            }
        }
        catch (Exception e) {
            this.logger.warn("Could not parse MAC-Addresses", (Object)e.getLocalizedMessage(), (Object)e);
        }
        return macs;
    }
}

