/*
 * Decompiled with CFR 0.152.
 */
package de.alamos.ioespa.rest.controller.ioprint;

import de.alamos.ioespa.helper.LoggerHelper;
import de.alamos.ioespa.services.ioprint.PrinterService;
import de.alamos.ioespa.services.ioprint.TestService;
import java.io.File;
import java.io.IOException;
import net.sf.jasperreports.engine.JRException;
import org.slf4j.Logger;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@Profile(value={"print"})
public class TestController {
    private final Logger logger = LoggerHelper.getLogger(this.getClass());
    private final TestService testService;
    private final PrinterService printerService;

    public TestController(TestService testService, PrinterService printerService) {
        this.testService = testService;
        this.printerService = printerService;
    }

    @GetMapping(value={"/test"})
    public String createPdf(RedirectAttributes redirAttrs) {
        try {
            File testPdf = this.testService.getTestPdf();
            this.logger.debug("Test Pdf successfully created");
            this.printerService.print(testPdf, 1);
        }
        catch (IOException | JRException e) {
            this.logger.warn("Fehler beim Erstellen der Testseite", e);
            redirAttrs.addFlashAttribute("error", (Object)"Fehler beim Erstellen der Testseite");
            return "redirect:/status";
        }
        catch (Exception e) {
            this.logger.warn("Druckfehler. M\u00f6glicherweise wurden keine aktiven Drucker gefunden.", (Throwable)e);
            redirAttrs.addFlashAttribute("error", (Object)"Druckfehler. M\u00f6glicherweise wurden keine aktiven Drucker gefunden.");
            return "redirect:/status";
        }
        redirAttrs.addFlashAttribute("success", (Object)"Testseite zum Drucken gesendet");
        return "redirect:/status";
    }
}

