/*
 * Decompiled with CFR 0.152.
 */
package de.alamos.ioespa.helper.mapper;

import de.alamos.ioespa.data.config.MqttConfig;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.util.Strings;

public final class ConfigurationPropertyMapper {
    public static final String MQTT_ACTIVE = "mqttActive";
    public static final String MQTT_SERVER = "mqttServer";
    public static final String MQTT_PORT = "mqttPort";
    public static final String MQTT_FALLBACK_SERVER = "mqttFallbackServer";
    public static final String MQTT_FALLBACK_PORT = "mqttFallbackPort";
    public static final String MQTT_USERNAME = "mqttUsername";
    public static final String MQTT_PASSWORD = "mqttPassword";
    public static final String MQTT_BASE_TOPIC = "mqttBaseTopic";
    public static final String PUBLIC_KEY_RECEIVER = "publicKeyReceiver";
    public static final String AUTHORIZATION = "authorization";
    public static final String NTP = "ntp";
    public static final String ID = "id";

    private ConfigurationPropertyMapper() {
    }

    public static Properties map(MqttConfig response) {
        Properties props = new Properties();
        props.setProperty("mqttServer1", response.getMqttServer1());
        props.setProperty("mqttPort1", String.valueOf(response.getMqttPort1()));
        if (Strings.isNotBlank((String)response.getMqttServer2())) {
            props.setProperty("mqttServer2", response.getMqttServer2());
        }
        if (response.getMqttPort2() != -1) {
            props.setProperty("mqttPort2", String.valueOf(response.getMqttPort2()));
        }
        if (StringUtils.isNotBlank((CharSequence)response.getMqttFallbackServer())) {
            props.setProperty(MQTT_FALLBACK_SERVER, response.getMqttFallbackServer());
        }
        if (StringUtils.isNotBlank((CharSequence)String.valueOf(response.getMqttFallbackPort()))) {
            props.setProperty(MQTT_FALLBACK_PORT, String.valueOf(response.getMqttFallbackPort()));
        }
        props.setProperty(MQTT_USERNAME, response.getMqttUsername());
        props.setProperty(MQTT_PASSWORD, response.getMqttPassword());
        props.setProperty(MQTT_BASE_TOPIC, response.getMqttBaseTopic());
        props.setProperty(MQTT_ACTIVE, String.valueOf(response.isMqttActive()));
        props.setProperty(PUBLIC_KEY_RECEIVER, response.getPublicKeyReceiver());
        props.setProperty(AUTHORIZATION, response.getAuthorization());
        props.setProperty(ID, response.getId());
        String ntp = "pool.ntp.org";
        if (StringUtils.isNotBlank((CharSequence)response.getNtp())) {
            ntp = response.getNtp();
        }
        props.setProperty(NTP, ntp);
        return props;
    }

    public static MqttConfig map(Properties props) {
        MqttConfig res = new MqttConfig();
        res.setMqttServer1(props.getProperty("mqttServer1"));
        res.setMqttPort1(Integer.parseInt(props.getProperty("mqttPort1")));
        if (props.containsKey("mqttServer2")) {
            res.setMqttServer2(props.getProperty("mqttServer2"));
        }
        if (props.containsKey("mqttPort2")) {
            res.setMqttPort2(Integer.parseInt(props.getProperty("mqttPort2")));
        }
        if (props.containsKey(MQTT_FALLBACK_SERVER)) {
            res.setMqttFallbackServer(props.getProperty(MQTT_FALLBACK_SERVER));
        }
        if (props.containsKey(MQTT_FALLBACK_PORT)) {
            res.setMqttFallbackPort(Integer.parseInt(props.getProperty(MQTT_FALLBACK_PORT)));
        }
        if (props.containsKey(MQTT_ACTIVE)) {
            res.setMqttActive(Boolean.parseBoolean(props.getProperty(MQTT_ACTIVE)));
        } else {
            res.setMqttActive(true);
        }
        res.setMqttUsername(props.getProperty(MQTT_USERNAME));
        res.setMqttPassword(props.getProperty(MQTT_PASSWORD));
        res.setMqttBaseTopic(props.getProperty(MQTT_BASE_TOPIC));
        res.setPublicKeyReceiver(props.getProperty(PUBLIC_KEY_RECEIVER));
        res.setAuthorization(props.getProperty(AUTHORIZATION));
        res.setId(props.getProperty(ID));
        if (props.containsKey(NTP)) {
            res.setNtp(props.getProperty(NTP));
        } else {
            res.setNtp("pool.ntp.org");
        }
        return res;
    }
}

