/*
 * Decompiled with CFR 0.152.
 */
package de.alamos.ioespa.espa.utils.serial;

import com.fazecast.jSerialComm.SerialPort;
import com.fazecast.jSerialComm.SerialPortDataListener;
import com.fazecast.jSerialComm.SerialPortEvent;
import de.alamos.ioespa.data.config.EspaConfig;
import de.alamos.ioespa.helper.LoggerHelper;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;

@SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"})
public abstract class PortListener
implements Runnable,
SerialPortDataListener {
    public static final int DEFAULT_DATABITS = 8;
    public static final int DEFAULT_BAUDRATE = 9600;
    public static final int SLEEP_IN_MS = 20000;
    public static final int SAFETY_SLEEP_TIME_IN_MS = 1000;
    public static final int PROCESS_TIMEOUT_IN_S = 5;
    private SerialPort serialPort;
    private Charset encoding = null;
    private transient CharsetDecoder dec;
    private boolean isDTR = false;
    private boolean isRTS = false;
    private int dataBits = 8;
    private int stopBits = 3;
    private int parity = 2;
    private int baudRate = 9600;
    private final Logger logger = LoggerHelper.getLogger(this.getClass());

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    Thread.sleep(20000L);
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public synchronized void config(EspaConfig config) {
        this.isDTR = config.isDtr();
        this.isRTS = config.isRts();
        this.dataBits = config.getDatabits();
        this.stopBits = config.getStopbits();
        this.parity = config.getParity();
        this.baudRate = config.getBaudRate();
        this.setEncoding(config.getCharset());
    }

    public boolean openSerialPort(String portName) {
        boolean success;
        this.logger.info("\u00d6ffne Port '{}'...", (Object)portName);
        SerialPort[] ports = SerialPort.getCommPorts();
        Optional<SerialPort> portToUse = Arrays.stream(ports).filter(port -> StringUtils.equals((CharSequence)port.getSystemPortName(), (CharSequence)portName)).findFirst();
        if (portToUse.isEmpty()) {
            this.logger.warn("Port {} konnte nicht gefunden werden", (Object)portName);
            this.logger.debug("Verf\u00fcgbare Ports: {}", (Object)Arrays.stream(ports).map(SerialPort::getSystemPortName).collect(Collectors.joining(", ")));
            return false;
        }
        this.serialPort = portToUse.get();
        this.logger.debug("Port {} gefunden!", (Object)this.serialPort.getSystemPortName());
        this.serialPort.addDataListener((SerialPortDataListener)this);
        this.logger.debug("Setze Parameter: ");
        this.serialPort.setBaudRate(this.baudRate);
        this.serialPort.setParity(this.parity);
        this.serialPort.setNumDataBits(this.dataBits);
        this.serialPort.setNumStopBits(this.stopBits);
        if (this.isDTR) {
            this.serialPort.setDTR();
        }
        if (this.isRTS) {
            this.serialPort.setRTS();
        }
        if (!(success = this.serialPort.openPort(1000))) {
            this.logger.warn("Serialport {} konnte nicht korrekt ge\u00f6ffnet werden", (Object)this.serialPort.getSystemPortName());
            return false;
        }
        this.logComSettings();
        if (this.encoding != null) {
            this.dec = this.encoding.newDecoder();
        }
        if (this.dec == null) {
            this.dec = Charset.defaultCharset().newDecoder();
        }
        this.dec.onMalformedInput(CodingErrorAction.IGNORE);
        if (!SystemUtils.IS_OS_WINDOWS) {
            this.logger.info("Starting Raw-Mode...");
            try {
                String execCommand = String.format("stty -F /dev/%s raw -echo -echoe -echok", portName);
                this.logger.debug("Command: {}", (Object)execCommand);
                Process process = Runtime.getRuntime().exec(new String[]{"sudo", "sh", "-c", execCommand});
                boolean successRawMode = process.waitFor(5L, TimeUnit.SECONDS);
                this.logger.info("SuccessRawMode {}: {}", (Object)portName, (Object)successRawMode);
            }
            catch (Exception e) {
                this.logger.error("Error starting Raw-Mode for {}", (Object)portName, (Object)e);
            }
        }
        this.logger.info("Serialport '{}' erfolgreich ge\u00f6ffnet", (Object)portName);
        return true;
    }

    private void logComSettings() {
        this.logger.debug("Baudrate: \t{}", (Object)this.baudRate);
        this.logger.debug("dataBits: \t{}", (Object)this.dataBits);
        switch (this.stopBits) {
            case 1: {
                this.logger.debug("stopBits: \t1");
                break;
            }
            case 3: {
                this.logger.debug("stopBits: \t2");
                break;
            }
            case 2: {
                this.logger.debug("stopBits: \t1.5");
                break;
            }
        }
        this.logger.debug("DTR: \t{}", (Object)this.isDTR);
        this.logger.debug("RTS: \t{}", (Object)this.isRTS);
        int flowControl = -1;
        this.logger.debug("FlowControl: {}", (Object)flowControl);
        switch (this.parity) {
            case 0: {
                this.logger.debug("parity: \tKeine");
                break;
            }
            case 1: {
                this.logger.debug("parity: \tUngleich");
                break;
            }
            case 2: {
                this.logger.debug("parity: \tGleich");
                break;
            }
            case 3: {
                this.logger.debug("parity: \tMarkiert");
                break;
            }
            case 4: {
                this.logger.debug("parity: \tLeer");
                break;
            }
        }
    }

    private void dataAvailable() {
        try {
            int available = this.serialPort.bytesAvailable();
            byte[] buffer = new byte[available];
            int numRead = this.serialPort.readBytes(buffer, buffer.length);
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < numRead; ++i) {
                builder.append(i).append(": ").append(buffer[i]).append(", ");
            }
            this.logger.debug("> {} ({})", (Object)builder, (Object)numRead);
            this.dataAvailable(buffer);
        }
        catch (Exception e) {
            this.logger.error("Fehler beim Lesen empfangener Daten", (Throwable)e);
        }
    }

    protected abstract void dataAvailable(byte[] var1);

    @SuppressFBWarnings(value={"DM_DEFAULT_ENCODING"})
    public void send(byte[] bytes) {
        this.logger.debug("Sende '{}' bytes", (Object)bytes.length);
        this.logger.debug("Sende: {}", (Object)new String(bytes));
        this.logger.debug("Sende Bytes: {}", (Object)Arrays.toString(bytes));
        OutputStream stream = this.serialPort.getOutputStream();
        try {
            stream.write(bytes);
            stream.flush();
            this.logger.debug("Flush()");
        }
        catch (IOException e) {
            this.logger.error("Fehler beim Senden der Daten", (Throwable)e);
        }
    }

    public int getListeningEvents() {
        return 1;
    }

    public void serialEvent(SerialPortEvent event) {
        this.logger.trace("serialEvent({}) for {}...", (Object)event.getEventType(), (Object)event.getSerialPort().getPortDescription());
        if (event.getEventType() == 1) {
            this.dataAvailable();
        }
    }

    public void setEncoding(String encoding) {
        if (!Charset.isSupported(encoding)) {
            this.logger.debug(String.format("Zeichensatz '%s' ist auf diesem System nicht verf\u00fcgbar.%nListe verf\u00fcgbarer Zeichens\u00e4tze: %s", encoding, Arrays.toString(Charset.availableCharsets().keySet().toArray())));
        } else {
            this.encoding = Charset.forName(encoding);
            this.logger.debug("Verwende Zeichensatz: {}", (Object)encoding);
        }
    }

    public String getName() {
        return this.serialPort.getSystemPortName();
    }

    public void closeSerialPort() {
        this.logger.info("Schlie\u00dfe Serial-Port {}...", (Object)this.serialPort.getSystemPortName());
        this.serialPort.closePort();
        this.serialPort.removeDataListener();
        this.logger.info("Serialport {} geschlossen!", (Object)this.serialPort.getSystemPortName());
    }
}

