/*
 * Decompiled with CFR 0.152.
 */
package de.alamos.ioespa.espa;

import de.alamos.ioespa.IOEspaApplication;
import de.alamos.ioespa.espa.EEspaCallSign;
import de.alamos.ioespa.espa.ESPAHelper;
import de.alamos.ioespa.espa.EspaLogMessageCreator;
import de.alamos.ioespa.espa.utils.EspaState;
import de.alamos.ioespa.espa.utils.SerialLogCollector;
import de.alamos.ioespa.espa.utils.SerialLogEntry;
import de.alamos.ioespa.espa.utils.serial.PortListener;
import de.alamos.ioespa.helper.LoggerHelper;
import de.alamos.ioespa.helper.SignedByteHelper;
import de.alamos.ioespa.services.TimeService;
import de.alamos.ioespa.services.ioespa.AlarmService;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import lombok.Generated;
import org.slf4j.Logger;

public class EspaCommunicator {
    public static final int ETX = 3;
    public static final int EOT = 4;
    public static final int ASCII_1 = 49;
    public static final int ASCII_2 = 50;
    public static final int ENQ = 5;
    public static final int ENQ_OFFSET = 3;
    public static final int MAX_SIZE_OF_CACHE = 5000;
    private final ExecutorService executor = Executors.newCachedThreadPool();
    public static final int MAX_ALARM_TEXTS = 10;
    public static final int MAX_HEARTBEAT_DIFF_IN_MS = 10000;
    private final PortListener port;
    private final Logger logger = LoggerHelper.getLogger((String)this.getClass().getSimpleName());
    private List<Byte> currentData = new ArrayList();
    private LocalDateTime lastHeartbeat;
    private long heartbeatCounter = 0L;
    private long lastAlarm = -1L;
    private final List<String> lastAlarmTexts = new ArrayList();
    private EspaState state = EspaState.WAITING_FOR_ALARM;
    private final List<Byte> messageArray = new ArrayList();
    private final SerialLogCollector serialLogCollector;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public EspaCommunicator(PortListener port, SerialLogCollector serialLogCollector) {
        this.port = port;
        this.serialLogCollector = serialLogCollector;
    }

    protected void handleInput(byte[] buffer) {
        this.handleInputInternal(buffer);
    }

    public List<Byte> handleInputInternal(byte[] buffer) {
        String str = SignedByteHelper.convert((byte[])buffer);
        if (this.serialLogCollector != null) {
            this.serialLogCollector.add(SerialLogEntry.builder().direction(SerialLogEntry.Direction.RECEIVE).length((long)buffer.length).message(str).build());
        }
        for (byte b : buffer) {
            this.currentData.add(b);
        }
        this.logger.info("[[{}]] Aktuelle Daten [{}]: {} ({})", new Object[]{this.state, this.currentData.size(), str, EspaLogMessageCreator.createEspaLog((List)this.currentData)});
        if (!this.messageArray.isEmpty()) {
            this.logger.info("[[{}]] Aktuelle Message-Daten [{}]: {} ({})", new Object[]{this.state, this.messageArray.size(), str, EspaLogMessageCreator.createEspaLog((List)this.messageArray)});
        }
        this.currentData = this.checkForNewMessage(this.currentData.toArray(new Byte[0]));
        this.currentData = this.checkForHeartbeat(this.currentData.toArray(new Byte[0]));
        this.currentData = this.checkForEndOfMessage(this.currentData.toArray(new Byte[0]));
        this.doSafetyCheckForTooLongMessages();
        return this.currentData;
    }

    private void doSafetyCheckForTooLongMessages() {
        if (this.currentData.size() > 5000) {
            this.logger.error("FATAL: Size of currentData exceeded max allowed size of {}", (Object)5000);
            this.currentData.clear();
        }
        if (this.messageArray.size() > 5000) {
            this.logger.error("FATAL: Size of messageArray exceeded max allowed size of {}", (Object)5000);
            this.messageArray.clear();
        }
    }

    private List<Byte> checkForEndOfMessage(Byte[] buffer) {
        ArrayList<Byte> byteArray = new ArrayList<Byte>();
        for (int i = 0; i < buffer.length; ++i) {
            Byte byt = buffer[i];
            if (this.state == EspaState.END_OF_TEXT) {
                this.state = EspaState.BCC;
                this.messageArray.add(byt);
                byte[] byteMessages = new byte[this.messageArray.size()];
                for (int ii = 0; ii < this.messageArray.size(); ++ii) {
                    byteMessages[ii] = (Byte)this.messageArray.get(ii);
                }
                String message = SignedByteHelper.convert((byte[])byteMessages);
                this.handleMessage(byteMessages, message);
                this.messageArray.clear();
                this.state = EspaState.WAITING_FOR_ALARM;
                continue;
            }
            if (byt == 1) {
                this.logger.info("Start parsing message....");
                this.state = EspaState.RECEIVING;
                this.messageArray.add(byt);
                continue;
            }
            if (this.state == EspaState.RECEIVING && byt == 3) {
                this.logger.info("Received End Of Text");
                this.state = EspaState.END_OF_TEXT;
                this.messageArray.add(byt);
                continue;
            }
            if (this.state == EspaState.WAITING_FOR_ALARM && byt == 4) {
                this.logger.info("Received EOT without start of message! Skipping it..");
                continue;
            }
            if (this.state == EspaState.RECEIVING) {
                this.messageArray.add(byt);
                continue;
            }
            byteArray.add(byt);
        }
        return byteArray;
    }

    public ArrayList<Byte> checkForNewMessage(Byte[] buffer) {
        ArrayList<Byte> byteArray = new ArrayList<Byte>();
        for (int i = 0; i < buffer.length; ++i) {
            Byte nextPlus2Byt;
            Byte nextPlus1Byt;
            Byte nextByt;
            Byte byt = buffer[i];
            if (byt == 49 && i + 1 <= buffer.length - 1 && (nextByt = buffer[i + 1]) == 5 && i + 2 <= buffer.length - 1 && (nextPlus1Byt = buffer[i + 2]) == 50 && i + 3 <= buffer.length - 1 && (nextPlus2Byt = buffer[i + 3]) == 5) {
                this.logger.info("\ud83d\udd34 Neue Espa-Nachricht verf\u00fcgbar!");
                this.sendAcknowledge(true);
                i += 3;
                continue;
            }
            byteArray.add(byt);
        }
        return byteArray;
    }

    public ArrayList<Byte> checkForHeartbeat(Byte[] buffer) {
        ArrayList<Byte> byteArray = new ArrayList<Byte>();
        for (int i = 0; i < buffer.length; ++i) {
            Byte nextByt;
            Byte byt = buffer[i];
            if (byt == 50 && i + 1 <= buffer.length - 1 && (nextByt = buffer[i + 1]) == 5) {
                ++this.heartbeatCounter;
                this.logger.debug("ESPA Heartbeat ({}) received! (2<ENQ>)", (Object)this.heartbeatCounter);
                this.sendEndOfTransmission();
                this.logger.debug("Heartbeat {} empfangen und best\u00e4tigt", (Object)this.heartbeatCounter);
                this.lastHeartbeat = LocalDateTime.now();
                ++i;
                continue;
            }
            byteArray.add(byt);
        }
        return byteArray;
    }

    private void handleMessage(byte[] rawMessage, String message) {
        try {
            this.logger.info("ESPA-Meldung erhalten (message): {}", (Object)message);
            this.logger.info("ESPA-Meldung erhalten (rawMessage): {}", (Object)new String(rawMessage, StandardCharsets.UTF_8));
            this.logger.info("ESPA-Meldung erhalten: {}", (Object)EspaLogMessageCreator.createEspaLog((String)message));
            if (!ESPAHelper.isChecksumOK((byte[])rawMessage)) {
                this.logger.error("Pr\u00fcfsumme nicht OK: {}", (Object)EspaLogMessageCreator.createEspaLog((String)message));
                this.sendAcknowledge(false);
                return;
            }
            this.sendAcknowledge(true);
            String finalMessage = message = EspaLogMessageCreator.createEspaLog((String)message);
            Future<?> future = this.executor.submit(() -> {
                this.logger.info("Verarbeite Alarm ({})...", (Object)finalMessage);
                this.lastAlarm = ((TimeService)IOEspaApplication.getApplicationContext().getBean(TimeService.class)).getAdjustedSystemTime();
                this.lastAlarmTexts.add(finalMessage);
                if (this.lastAlarmTexts.size() > 10) {
                    this.lastAlarmTexts.remove(0);
                }
                this.logger.info("Aktualisiere Zeitstempel letzter Alarm: {}", (Object)this.lastAlarm);
                ((AlarmService)IOEspaApplication.getApplicationContext().getBean(AlarmService.class)).handleAlarm(finalMessage, this.port.getName());
                this.logger.info("Alarmverarbeitung abgeschlossen");
            });
            this.logger.debug("Future: {}", (Object)future.hashCode());
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private void sendEndOfTransmission() {
        if (this.port == null) {
            return;
        }
        this.logger.debug("Sende EndOfTransmission");
        byte[] toSend = new byte[]{EEspaCallSign.EOT.getCallSignByte()};
        this.port.send(toSend);
        this.serialLogCollector.add(SerialLogEntry.builder().direction(SerialLogEntry.Direction.SEND).length((long)toSend.length).message(new String(toSend, StandardCharsets.UTF_8)).build());
        this.logger.debug("EndOfTransmission gesendet");
    }

    private void sendAcknowledge(boolean isPositive) {
        if (this.port == null) {
            return;
        }
        if (isPositive) {
            byte[] toSend = new byte[]{EEspaCallSign.ACK.getCallSignByte()};
            this.port.send(toSend);
            this.serialLogCollector.add(SerialLogEntry.builder().direction(SerialLogEntry.Direction.SEND).length((long)toSend.length).message(new String(toSend, StandardCharsets.UTF_8)).build());
            this.logger.debug("OK Acknowledge gesendet");
        } else {
            byte[] toSend = new byte[]{EEspaCallSign.NEG_ACK.getCallSignByte()};
            this.port.send(toSend);
            this.serialLogCollector.add(SerialLogEntry.builder().direction(SerialLogEntry.Direction.SEND).length((long)toSend.length).message(new String(toSend, StandardCharsets.UTF_8)).build());
            this.logger.debug("NOK Negative Acknowledge gesendet");
        }
    }

    public boolean hasEspaHeartbeat() {
        if (this.lastHeartbeat == null) {
            return false;
        }
        long diff = Duration.between(LocalDateTime.now(), this.lastHeartbeat).toMillis();
        return diff <= 10000L;
    }

    @Generated
    public ExecutorService getExecutor() {
        return this.executor;
    }

    @Generated
    public PortListener getPort() {
        return this.port;
    }

    @Generated
    public Logger getLogger() {
        return this.logger;
    }

    @Generated
    public List<Byte> getCurrentData() {
        return this.currentData;
    }

    @Generated
    public LocalDateTime getLastHeartbeat() {
        return this.lastHeartbeat;
    }

    @Generated
    public long getHeartbeatCounter() {
        return this.heartbeatCounter;
    }

    @Generated
    public long getLastAlarm() {
        return this.lastAlarm;
    }

    @Generated
    public List<String> getLastAlarmTexts() {
        return this.lastAlarmTexts;
    }

    @Generated
    public EspaState getState() {
        return this.state;
    }

    @Generated
    public List<Byte> getMessageArray() {
        return this.messageArray;
    }

    @Generated
    public SerialLogCollector getSerialLogCollector() {
        return this.serialLogCollector;
    }

    @Generated
    public void setHeartbeatCounter(long heartbeatCounter) {
        this.heartbeatCounter = heartbeatCounter;
    }
}

