/*
 * Decompiled with CFR 0.152.
 */
package de.alamos.ioespa.services.ioprint;

import de.alamos.ioespa.helper.ExecuteCommandHelper;
import de.alamos.ioespa.helper.LoggerHelper;
import de.alamos.ioespa.helper.exceptions.GenericException;
import de.alamos.ioespa.services.FileService;
import de.alamos.ioespa.services.FrpService;
import de.alamos.ioespa.services.config.ConfigurationService;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;

@Service
@Profile(value={"print"})
public class FrpServicePrint
implements FrpService {
    public static final int TIME_TO_WORK = 7;
    public static final ChronoUnit TIME_UNIT_TO_WORK = ChronoUnit.DAYS;
    public static final int WAIT_SERVICE_RUNNING_SEC = 10;
    private final Logger logger = LoggerHelper.getLogger(this.getClass());
    private final FileService fileService;
    private final ConfigurationService configurationService;
    private ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    @Value(value="${frp.frpFileTemplateResource}")
    private String frpFileTemplateResource;
    @Value(value="${frp.configFilePath}")
    private String frpFilePath;
    @Value(value="${updating.frpRunningPath}")
    private String frpRunningPath;
    @Value(value="${frp.frpServerIP}")
    private String frpServerIP;
    @Value(value="${frp.frpRunningTimePath}")
    private String frpRunningTimePath;
    private final ExecuteCommandHelper commandHelper;
    private final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm:ss z");
    private String userId;
    private static final String FRP_START_RUNNING_COMMAND = "echo \"FRP service start\" \nsudo service frp start ";
    private static final String FRP_NOT_START_RUNNING_COMMAND = "echo \"FRP service did not start\"";

    public FrpServicePrint(FileService fileService, ConfigurationService configurationService, ExecuteCommandHelper commandHelper) {
        this.fileService = fileService;
        this.configurationService = configurationService;
        this.commandHelper = commandHelper;
    }

    public void writeFrpRunningFile() {
        this.writeFrpRunningFile(this.commandHelper.isServiceRunning("frp"));
    }

    public void writeFrpRunningFile(boolean isRun) {
        if (isRun) {
            this.logger.debug("FRP service started, write service run file");
            this.fileService.writeFile(this.frpRunningPath, FRP_START_RUNNING_COMMAND);
        } else {
            this.logger.debug("FRP service did not start, clean service run file");
            this.fileService.writeFile(this.frpRunningPath, FRP_NOT_START_RUNNING_COMMAND);
        }
    }

    public String getFrpRunningTime() {
        this.logger.trace("start getFrpRunningTime()");
        Optional frpRunningTime = this.fileService.readFile(this.frpRunningTimePath);
        String time = frpRunningTime.orElse("");
        this.logger.debug("FRP Running Time '{}'", (Object)time);
        return time;
    }

    private void startService() throws GenericException {
        this.commandHelper.startService("frp", false);
        try {
            TimeUnit.SECONDS.sleep(10L);
        }
        catch (InterruptedException e) {
            this.logger.warn("Error waiting service running", (Throwable)e);
        }
        if (!this.isFrpRunning()) {
            this.logger.error("FRP not started");
            this.fileService.writeFile(this.frpRunningTimePath, "");
            this.logger.debug("Service FRP file '{}' is clean", (Object)this.frpRunningTimePath);
            this.writeFrpRunningFile(false);
            throw new GenericException("FRP not started");
        }
        this.logger.info("FRP successfully started");
        this.writeFrpRunningFile(true);
    }

    public boolean isFrpRunning() {
        return this.commandHelper.isServiceRunning("frp");
    }

    private String prepareConfigFile() throws GenericException {
        Optional frpFile = this.fileService.readResourceAsString(this.frpFileTemplateResource);
        if (frpFile.isEmpty()) {
            this.logger.error("FRP not run, ini file template not found");
            throw new GenericException("FRP not run, ini file template not found");
        }
        String frpUserId = this.getFrpUserId();
        this.logger.debug("FRP service has userId {}", (Object)frpUserId);
        this.logger.debug("FRP service has frpServerIP {}", (Object)this.frpServerIP);
        String format = String.format((String)frpFile.get(), this.frpServerIP, frpUserId);
        this.fileService.writeFile(this.frpFilePath, format);
        this.logger.debug("FRP Configuration File '{}' successfully  wrote", (Object)this.frpFilePath);
        this.logger.debug("FRP Configuration File '{}' contains data: '{}'", (Object)this.frpFilePath, (Object)format);
        return frpUserId;
    }

    private void startStopSchedule(long delay, TimeUnit timeUnit) {
        this.scheduler.shutdownNow();
        this.scheduler = Executors.newSingleThreadScheduledExecutor();
        this.scheduler.schedule(() -> this.stopFrp(), delay, timeUnit);
        this.logger.info("FRP Schedule successfully started");
    }

    public String startFrp(boolean withStopScheduler) throws GenericException {
        this.logger.info("START FRP...");
        if (withStopScheduler) {
            String startTime = ZonedDateTime.now().format(this.formatter);
            this.logger.debug("Service FRP starting time {}", (Object)startTime);
            this.fileService.writeFile(this.frpRunningTimePath, startTime);
            this.logger.debug("Service FRP starting time {} wrote in file '{}'", (Object)startTime, (Object)this.frpRunningTimePath);
        } else {
            this.fileService.writeFile(this.frpRunningTimePath, "");
            this.logger.debug("Service FRP file '{}' is clean", (Object)this.frpRunningTimePath);
        }
        return this.startFrp(withStopScheduler, 7L, TimeUnit.of(TIME_UNIT_TO_WORK));
    }

    public String startFrp(boolean withStopScheduler, long delay, TimeUnit timeUnit) throws GenericException {
        String frpUserId = this.prepareConfigFile();
        this.startService();
        if (withStopScheduler) {
            this.startStopSchedule(delay, timeUnit);
        } else {
            this.logger.info("FRP must not stopped");
        }
        return frpUserId;
    }

    public String getFrpUserId() {
        if (this.userId == null) {
            this.userId = this.configurationService.getMacAddress().orElse(UUID.randomUUID().toString());
        }
        return this.userId;
    }

    public void stopFrp() {
        this.logger.info("RUN FRP stopping...");
        this.fileService.writeFile(this.frpRunningTimePath, "");
        this.logger.debug("FRP Config file '{}' successfully  clean", (Object)this.frpRunningTimePath);
        this.commandHelper.stopService("frp", false);
        this.logger.info("{} Service STOPPED", (Object)"frp");
        this.writeFrpRunningFile();
    }

    public void stopFrpAndScheduler() {
        this.stopFrp();
        this.scheduler.shutdownNow();
        this.logger.debug("FRP Scheduler STOPPED");
    }

    public boolean isSchedulerWork() {
        return !this.scheduler.isShutdown();
    }

    public void rescheduleStopping() {
        block5: {
            String frpRunningTime = this.getFrpRunningTime();
            if (StringUtils.isBlank((CharSequence)frpRunningTime)) {
                this.stopFrpAndScheduler();
                return;
            }
            try {
                ZonedDateTime startingTime = ZonedDateTime.parse(frpRunningTime.trim(), this.formatter);
                ZonedDateTime endingTime = startingTime.plus(7L, TIME_UNIT_TO_WORK);
                ZonedDateTime now = ZonedDateTime.now();
                if (!now.isBefore(endingTime)) break block5;
                long diff = ChronoUnit.SECONDS.between(startingTime, now);
                try {
                    this.startFrp(true, diff, TimeUnit.SECONDS);
                }
                catch (Exception e) {
                    this.logger.error("Can not start FRP", (Throwable)e);
                }
                return;
            }
            catch (Exception e) {
                this.logger.error("Starting Time can not be parsed", (Throwable)e);
            }
        }
        this.stopFrpAndScheduler();
    }
}

