/*
 * Decompiled with CFR 0.152.
 */
package de.alamos.ioespa.services.ioprint;

import de.alamos.ioespa.data.config.ConfigHolder;
import de.alamos.ioespa.helper.ExecuteCommandHelper;
import de.alamos.ioespa.helper.LoggerHelper;
import de.alamos.ioespa.services.ioprint.PrinterService;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;

@Service
@Profile(value={"print"})
public class CleaningService {
    public static final int SECONDS = 60;
    public static final int TASK_CMD_LENGTH_4 = 4;
    private final Logger logger = LoggerHelper.getLogger(this.getClass());
    private final Long cleaningInterval;
    private final PrinterService printerService;
    private final ScheduledExecutorService executorService;
    private final ExecuteCommandHelper commandHelper;

    public CleaningService(ConfigHolder configHolder, PrinterService printerService, ExecuteCommandHelper commandHelper) {
        this.cleaningInterval = configHolder.getAppConfig().getCleaningInterval();
        this.printerService = printerService;
        this.commandHelper = commandHelper;
        this.executorService = Executors.newScheduledThreadPool(1);
        if (this.cleaningInterval > 0L) {
            this.executorService.scheduleAtFixedRate(() -> this.schedule(), 1L, this.cleaningInterval, TimeUnit.MINUTES);
        }
    }

    private void cancelJob(String jobName) {
        try {
            if (this.commandHelper.cancelJob(jobName)) {
                this.logger.debug("Job {} canceled", (Object)jobName);
            }
        }
        catch (IOException e) {
            this.logger.error("Error when trying to cancel PrintJob {}", (Object)jobName, (Object)e);
        }
    }

    private void schedule() {
        this.logger.debug("schedule CleaningService run");
        Map tasks = this.tasks();
        tasks.forEach((printer, job) -> {
            long currentInterval = this.printerService.checkJobTime(printer, job) / 60L;
            if (currentInterval >= this.cleaningInterval) {
                this.logger.debug("printer {} start print {} job {} minutes ago (>={} minutes). Try to cancel", new Object[]{printer, job, currentInterval, this.cleaningInterval});
                this.cancelJob(job);
            } else {
                this.logger.debug("printer {} start print {} job {} minutes ago (<{} minutes)", new Object[]{printer, job, currentInterval, this.cleaningInterval});
            }
        });
    }

    private Map<String, String> tasks() {
        HashMap<String, String> printersPrintingJob = new HashMap<String, String>();
        try {
            List printersStatus = this.commandHelper.getPrintersCurrentStatus();
            printersStatus.stream().filter(stat -> stat.contains("now printing")).forEach(stat -> {
                String[] s = stat.split(" ");
                String printerName = s[1].trim();
                if (this.printerService.isEnable(printerName) && s.length > 4) {
                    printersPrintingJob.put(printerName, s[4].trim());
                }
            });
        }
        catch (Exception e) {
            this.logger.error("Error of parsing printers status", (Throwable)e);
        }
        return printersPrintingJob;
    }
}

