/*
 * Decompiled with CFR 0.152.
 */
package de.alamos.ioespa.services.ioespa;

import de.alamos.ioespa.data.config.ConfigHolder;
import de.alamos.ioespa.data.config.MqttConfig;
import de.alamos.ioespa.helper.LoggerHelper;
import de.alamos.ioespa.services.HeartbeatService;
import de.alamos.ioespa.services.StarterService;
import de.alamos.ioespa.services.ioespa.ESPAHeartbeatAnalyzerService;
import de.alamos.ioespa.services.ioespa.EspaControlService;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

@Component
@Profile(value={"espa"})
public class StarterServiceEspa
implements StarterService {
    private final MqttConfig config;
    private final EspaControlService espaControlService;
    private final HeartbeatService heartbeatService;
    private final ESPAHeartbeatAnalyzerService espaHeartbeatAnalyzerService;
    private final Logger logger = LoggerHelper.getLogger(this.getClass());

    @Autowired
    public StarterServiceEspa(ESPAHeartbeatAnalyzerService espaHeartbeatAnalyzerService, ConfigHolder configHolder, EspaControlService espaControlService, HeartbeatService heartbeatService) {
        this.config = configHolder.getMqttConfig();
        this.espaControlService = espaControlService;
        this.heartbeatService = heartbeatService;
        this.espaHeartbeatAnalyzerService = espaHeartbeatAnalyzerService;
    }

    public void init() {
        this.init(null);
    }

    public void init(String[] args) {
        if (this.config == null) {
            this.logger.warn("Keine Konfiguration gefunden, Anwendung wird nicht vollst\u00e4ndig gestartet, bitte in Weboberfl\u00e4che Konfiguration hinterlegen");
            return;
        }
        this.espaControlService.init();
        this.heartbeatService.scheduleHeartbeat();
        this.espaHeartbeatAnalyzerService.startHeartbeatAnalyzer();
    }
}

