/*
 * Decompiled with CFR 0.152.
 */
package de.alamos.ioespa.services;

import de.alamos.ioespa.helper.LoggerHelper;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.springframework.boot.system.JavaVersion;
import org.springframework.boot.system.SystemProperties;
import org.springframework.core.SpringVersion;
import org.springframework.stereotype.Service;

@Service
public class VersionService {
    private final Logger logger = LoggerHelper.getLogger(this.getClass());
    private String version = this.getClass().getPackage().getImplementationVersion();

    public VersionService() {
        if (StringUtils.isBlank((CharSequence)this.version)) {
            this.version = "-.-.-";
        }
        this.logger.info("Version: {}", (Object)this.version);
    }

    public String getCurrentVersion() {
        return this.version;
    }

    public String getSpringVersion() {
        return SpringVersion.getVersion();
    }

    public String getJavaVersion() {
        return String.format("%s (%s)", JavaVersion.getJavaVersion(), SystemProperties.get((String[])new String[]{"java.vendor"}));
    }
}

