/*
 * Decompiled with CFR 0.152.
 */
package de.alamos.ioespa.rest.controller;

import de.alamos.ioespa.helper.LoggerHelper;
import de.alamos.ioespa.services.AppInfoService;
import de.alamos.ioespa.services.FrpService;
import org.slf4j.Logger;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
public class FrpController {
    private final Logger logger = LoggerHelper.getLogger(this.getClass());
    private final FrpService frpService;
    private final AppInfoService appInfoService;

    public FrpController(FrpService frpService, AppInfoService appInfoService) {
        this.frpService = frpService;
        this.appInfoService = appInfoService;
    }

    @GetMapping(value={"/remote"})
    public String getFilesPage(Model model) {
        model.addAttribute("appName", (Object)this.appInfoService.getAppName());
        boolean isFrpRunning = this.frpService.isFrpRunning();
        model.addAttribute("isFrpRunning", (Object)isFrpRunning);
        if (isFrpRunning) {
            model.addAttribute("frpRunningTime", (Object)this.frpService.getFrpRunningTime());
            model.addAttribute("isSchedulerWork", (Object)this.frpService.isSchedulerWork());
            model.addAttribute("frpUserId", (Object)this.frpService.getFrpUserId());
        }
        return "remote_und_update";
    }

    @GetMapping(value={"/remote/startFRP"})
    public String startFrp(RedirectAttributes redirAttrs) {
        this.logger.trace("start /remote/startFRP");
        try {
            this.frpService.startFrp(true);
        }
        catch (Exception e) {
            this.logger.error("Error start FRP", (Throwable)e);
            redirAttrs.addFlashAttribute("error", (Object)"Der Dienst kann nicht gestartet werden. Weitere Informationen finden Sie in der Protokolldatei.");
        }
        return "redirect:/remote";
    }

    @GetMapping(value={"/remote/stopFRP"})
    public String stopFrp(RedirectAttributes redirAttrs) {
        this.logger.trace("start /remote/stopFRP");
        this.frpService.stopFrpAndScheduler();
        return "redirect:/remote";
    }
}

