/*
 * Decompiled with CFR 0.152.
 */
package de.alamos.ioespa.helper;

import de.alamos.ioespa.helper.LoggerHelper;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalField;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
@SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD", "DM_CONVERT_CASE"})
public class ExecuteCommandHelper {
    private static final Logger LOGGER = LoggerHelper.getLogger(ExecuteCommandHelper.class);
    public static final int EXEC_SLEEP_IN_MS = 100;
    public static final int PRINT_COMMAND_LENGTH = 3;
    public static final int RESTART_CUPS_SLEEP_S = 30;
    public static final int INDX_AM = 6;
    public static final int INDX_PM = 5;
    private static final String CREATE_PRINTER = "lpadmin -p %s -E -v \"%s\" -m %s";
    private static final String REMOVE_PRINTER = "lpadmin -x %s";
    private static final String GET_MEMORY_INFO = "df -h";
    private final Logger logger = LoggerHelper.getLogger(this.getClass());
    public static final String USB_INFO = "lsusb";
    public static final String FRP_SERVICE_NAME = "frp";
    public static final String IS_SERVICE_RUN = "sudo systemctl list-units --type=service --state=running | grep %s.service";
    public static final String START_SERVICE = "sudo service %s start";
    public static final String STOP_SERVICE = "sudo service %s stop";
    public static final String SERIAL_NUMBER = " sudo dmidecode -t system | grep Serial";
    public static final String RESTART_UDEV = "sudo service udev restart";
    public static final String RESTART_CUPS = "sudo service cups restart";
    public static final String RELOAD_RULES = "sudo udevadm control --reload-rules";
    public static final String REMOVE_JOB = "cancel %s";
    public static final String REMOVE_ALL_JOB = "cancel -a";
    public static final String REMOVE_ALL_JOB_IN_PRINTER = "cancel -a  %s";
    public static final String RESUME_PRINTER = "lpadmin -p %s -E";
    public static final String PRINTERS_CURRENT_STATUS = "lpstat -p";
    public static final String PRINTER_CURRENT_STATUS = "lpstat -p %s";
    public static final String CHECK_JOB_INFO = "lpstat -l -o %s  | grep ^%s";
    public static final String GET_ALL_JOBS = "lpstat -o";
    public static final String PRINT_FILE = "lp -n %d -d %s %s";
    public static final String PRINT_DUPLEX_FILE = "lp -n %d -d %s -o sides=two-sided-long-edge %s";
    public static final String CHECK_JOB_STATUS = "lpstat -W all -l -o %s  | grep -A 3 %s";
    public static final String HOSTNAME = "hostname -I ";
    public static final String SYSTEM_REBOOT = "sudo shutdown -r now";
    public static final String LIST_PRINTERS_URLS = "lpinfo -v";
    public static final String GET_IP_CONFIG = "ifconfig -a";
    private static final List<DateTimeFormatter> FORMATTERS = ExecuteCommandHelper.initFormatters();
    private static boolean blockForRestartingServices = false;
    private static boolean restartingServicesDone = true;
    private final ExecutorService executor = Executors.newSingleThreadExecutor();

    @NotNull
    private String execUbuntuCommand(String command, boolean shouldWait) throws IOException {
        this.logger.info("run execUbuntuCommand '{}'", (Object)command);
        if (shouldWait && blockForRestartingServices) {
            this.logger.debug("Waiting to services restart");
        }
        while (shouldWait && blockForRestartingServices) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                this.logger.warn("Error waiting to services restart", (Throwable)e);
            }
        }
        String[] cmd = new String[]{"/bin/sh", "-c", command};
        Process proc = Runtime.getRuntime().exec(cmd);
        String answer = new String(proc.getInputStream().readAllBytes(), StandardCharsets.UTF_8);
        this.logger.debug("execUbuntuCommand '{}' done. \n\tAnswer is '{}'", (Object)command, (Object)answer.trim());
        return answer;
    }

    @NotNull
    public String execUbuntuCommand(String command) throws IOException {
        return this.execUbuntuCommand(command, true);
    }

    public boolean isServiceRunning(String serviceName) {
        this.logger.debug("isServiceRunning serviceName - {} ", (Object)serviceName);
        try {
            String answer = this.execUbuntuCommand(String.format("sudo systemctl list-units --type=service --state=running | grep %s.service", serviceName));
            return org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)answer);
        }
        catch (Exception e) {
            this.logger.debug("Error to get running services", (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startStopService(String command, String serviceName, boolean blockForRestarting) {
        this.logger.debug("startStopService command - {}, serviceName - {}, blockForRestarting - {}", new Object[]{command, serviceName, blockForRestarting});
        try {
            if (blockForRestarting) {
                blockForRestartingServices = true;
                this.logger.trace("Blocked execUbuntuCommand while {} starting", (Object)serviceName);
            }
            String format = String.format(command, serviceName);
            this.execUbuntuCommand(format, false);
        }
        catch (Exception e) {
            this.logger.error("Error to start service {}", (Object)serviceName, (Object)e);
        }
        finally {
            if (blockForRestarting) {
                blockForRestartingServices = false;
                this.logger.trace("Unblocked execUbuntuCommand after {} starting", (Object)serviceName);
            }
        }
    }

    public void startService(String serviceName, boolean blockForRestarting) {
        this.startStopService("sudo service %s start", serviceName, blockForRestarting);
    }

    public void stopService(String serviceName, boolean blockForRestarting) {
        this.startStopService("sudo service %s stop", serviceName, blockForRestarting);
    }

    public Optional<String> print(int copies, String printerName, File file, boolean isDuplexOn) throws IOException {
        this.logger.info("PRINTING printer - {}, file - {}, copies - {}, duplex = {}", new Object[]{printerName, file.getAbsolutePath(), copies, isDuplexOn});
        String command = String.format(isDuplexOn ? "lp -n %d -d %s -o sides=two-sided-long-edge %s" : "lp -n %d -d %s %s", copies, printerName, file.getAbsolutePath());
        String answer = this.execUbuntuCommand(command);
        this.logger.debug("PRINTING {} answer is: {}", (Object)command, (Object)answer);
        if (answer.startsWith("request id is ")) {
            String[] split = answer.split(" ");
            String jobName = split[3];
            this.logger.info("New Job for {} created. JobId is {}", (Object)printerName, (Object)jobName);
            return Optional.of(jobName);
        }
        this.logger.error("For {} printer printing command answer is \n{}", (Object)printerName, (Object)answer);
        return Optional.empty();
    }

    public Optional<String> askJobStatus(String printerName, String jobName) throws IOException {
        this.logger.debug("askJobStatus printer - {}, jobName - {}", (Object)printerName, (Object)jobName);
        String command = String.format("lpstat -W all -l -o %s  | grep -A 3 %s", printerName, jobName);
        String answer = this.execUbuntuCommand(command);
        this.logger.debug("askJobStatus {} answer is: {}", (Object)command, (Object)answer);
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)answer)) {
            this.logger.warn("Job with ID {} for printer {} Has error (answer is empty)", (Object)jobName, (Object)printerName);
            return Optional.empty();
        }
        int n = answer.indexOf("Alerts:");
        if (n == -1) {
            this.logger.warn("Job with ID {} for printer {}  Has error (answer has not 'Alerts' part)", (Object)jobName, (Object)printerName);
            return Optional.empty();
        }
        int m = answer.indexOf("\n", n);
        if (m == -1) {
            m = answer.length() - 1;
        }
        return Optional.of(answer.substring(n + "Alerts:".length(), m).trim());
    }

    public List<String> getPrintersList() throws IOException {
        this.logger.debug("getPrintersList()");
        ArrayList<String> printers = new ArrayList<String>();
        String answer = this.execUbuntuCommand("lpstat -p");
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)answer)) {
            return printers;
        }
        Arrays.stream(answer.split("\n")).forEach(stat -> {
            String[] s = stat.split(" ");
            if (s.length > 1 && s[0].equals("printer")) {
                printers.add(s[1]);
            }
        });
        return printers;
    }

    public List<String> getOfflinePrintersList() {
        this.logger.debug("getOfflinePrintersList()");
        try {
            ArrayList<String> printers = new ArrayList<String>();
            String answer = this.execUbuntuCommand("lpstat -p");
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)answer)) {
                return printers;
            }
            Arrays.stream(answer.split("\n")).forEach(stat -> {
                String[] s = stat.split(" ");
                if (this.isPrinterOffline(stat) && s.length > 1 && s[0].equals("printer")) {
                    printers.add(s[1]);
                }
            });
            if (!printers.isEmpty()) {
                this.logger.info("{} printers is OFFLINE", (Object)String.join((CharSequence)", ", printers));
            }
            return printers;
        }
        catch (Exception e) {
            this.logger.error("Error to get offline printers", (Throwable)e);
            return new ArrayList<String>();
        }
    }

    public void resumePrinter(String printerName) {
        this.logger.info("try to resumePrinter name - {}", (Object)printerName);
        try {
            this.execUbuntuCommand(String.format("lpadmin -p %s -E", printerName));
        }
        catch (Exception e) {
            this.logger.error("Can not resume printer", (Throwable)e);
        }
    }

    private boolean isPrinterOffline(String stat) {
        return org.apache.commons.lang3.StringUtils.containsAnyIgnoreCase((CharSequence)stat, (CharSequence[])new CharSequence[]{"offline", "disabled", "paused"});
    }

    public Optional<String> getUsbInfo() throws IOException {
        this.logger.debug("getUsbInfo()");
        String answer = this.execUbuntuCommand("lsusb");
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)answer)) {
            return Optional.of(answer.toUpperCase());
        }
        return Optional.empty();
    }

    public void restartUdev() throws IOException {
        this.logger.debug("restartUdev()");
        try {
            blockForRestartingServices = true;
            this.logger.trace("Blocked execUbuntuCommand while UDEV restarting");
            this.execUbuntuCommand("sudo service udev restart", false);
        }
        finally {
            blockForRestartingServices = false;
            this.logger.trace("Unblocked execUbuntuCommand after UDEV restarting");
        }
    }

    public void reloadRules() throws IOException {
        this.logger.debug("reloadRules()");
        this.execUbuntuCommand("sudo udevadm control --reload-rules", false);
    }

    public void restartCups() throws IOException {
        this.logger.debug("restartCups()");
        try {
            blockForRestartingServices = true;
            this.logger.trace("Blocked execUbuntuCommand while CUPS restarting");
            this.execUbuntuCommand("sudo service cups restart", false);
            TimeUnit.SECONDS.sleep(30L);
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            blockForRestartingServices = false;
            this.logger.trace("Unblocked execUbuntuCommand after CUPS restarting");
        }
    }

    public String getPrinterStatus(String name) throws IOException {
        this.logger.debug("getPrinterStatus printer - {}", (Object)name);
        String answer = this.execUbuntuCommand(String.format("lpstat -p %s", name));
        this.logger.info("lpstat response with printer {} status is: {}", (Object)name, (Object)answer);
        return answer;
    }

    public List<String> getPrintersCurrentStatus() throws IOException {
        this.logger.debug("getPrintersCurrentStatus");
        String answer = this.execUbuntuCommand("lpstat -p");
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)answer)) {
            return List.of();
        }
        this.logger.debug("getPrintersCurrentStatus answer is: {}", (Object)answer);
        return Arrays.stream(answer.split("\n")).collect(Collectors.toList());
    }

    public Optional<ZonedDateTime> getJobStartingTime(String printerName, String jobName) throws IOException {
        this.logger.debug("getJobStartingTime printer - {}, jobName - {}", (Object)printerName, (Object)jobName);
        String command = String.format("lpstat -l -o %s  | grep ^%s", printerName, jobName);
        String answer = this.execUbuntuCommand(command);
        if (!StringUtils.hasLength((String)answer)) {
            this.logger.info("Job {} Starting in 'UNKNOWN'", (Object)jobName);
            return Optional.empty();
        }
        Optional parsedDate = this.parseJobStartingTime(answer);
        this.logger.info("Job {} Starting in '{}'", (Object)jobName, (Object)parsedDate);
        return parsedDate;
    }

    public String getRunningJobsAsPlainText() throws IOException {
        this.logger.debug("getRunningJobsAsPlainText");
        String jobInfo = this.execUbuntuCommand("lpstat -o").trim();
        this.logger.info("Running Jobs:\n{}", (Object)jobInfo);
        return jobInfo;
    }

    public String getIpConfigAsPlainText() {
        this.logger.debug("getIpConfigAsPlainText");
        String jobInfo = null;
        try {
            jobInfo = this.execUbuntuCommand("ifconfig -a").trim();
            this.logger.debug("IP config:\n{}", (Object)jobInfo);
            return jobInfo;
        }
        catch (IOException e) {
            this.logger.error("Die IP-Konfiguration kann nicht abgerufen werden", (Throwable)e);
            return "Die IP-Konfiguration kann nicht abgerufen werden";
        }
    }

    public Optional<ZonedDateTime> parseJobStartingTime(String answer) throws IOException {
        if (!StringUtils.hasLength((String)answer)) {
            return Optional.empty();
        }
        String dateStr = this.findDateInString(answer);
        return ExecuteCommandHelper.parseDate((String)dateStr);
    }

    @NotNull
    public static Optional<ZonedDateTime> parseDate(String dateStr) {
        int i = 0;
        if (!FORMATTERS.isEmpty()) {
            try {
                ZonedDateTime parse = ZonedDateTime.parse(dateStr, ((DateTimeFormatter)FORMATTERS.get(i++)).withZone(ZoneId.systemDefault()));
                return Optional.of(parse);
            }
            catch (DateTimeParseException e1) {
                LOGGER.trace("{} could not yet be parsed, try different formatter ({})", (Object)dateStr, (Object)i);
            }
        }
        while (i < FORMATTERS.size()) {
            try {
                ZonedDateTime parse = ZonedDateTime.parse(dateStr, (DateTimeFormatter)FORMATTERS.get(i++));
                return Optional.of(parse);
            }
            catch (DateTimeParseException e2) {
                LOGGER.trace("{} could not yet be parsed, try different formatter ({})", (Object)dateStr, (Object)i);
            }
        }
        LOGGER.error("Error parse date - {}", (Object)dateStr);
        return Optional.empty();
    }

    @NotNull
    private String findDateInString(String answer) {
        answer = answer.trim();
        String toUpper = answer.toUpperCase();
        String[] data = answer.split(" ");
        int n = toUpper.contains(" AM ") || toUpper.contains(" PM ") ? 6 : 5;
        int startInx = data.length - n;
        StringBuilder sb = new StringBuilder(data[startInx]);
        for (int i = 1; i < n; ++i) {
            sb.append(" ");
            sb.append(data[startInx + i]);
        }
        String dateStr = sb.toString();
        this.logger.debug("Date found '{}'", (Object)dateStr);
        return dateStr;
    }

    public boolean cancelJob(String jobName) throws IOException {
        this.logger.info("cancelJob jobName - {}", (Object)jobName);
        return org.apache.commons.lang3.StringUtils.isBlank((CharSequence)this.execUbuntuCommand(String.format("cancel %s", jobName)));
    }

    public boolean cancelAllJobs() throws IOException {
        this.logger.info("cancelAllJobs()");
        return org.apache.commons.lang3.StringUtils.isBlank((CharSequence)this.execUbuntuCommand("cancel -a"));
    }

    public boolean cancelAllJobs(String printerName) throws IOException {
        this.logger.info("cancelAllJobs printerName - {}", (Object)printerName);
        return org.apache.commons.lang3.StringUtils.isBlank((CharSequence)this.execUbuntuCommand(String.format("cancel -a  %s", printerName)));
    }

    public boolean systemReboot() {
        this.logger.info("SYSTEM_REBOOT");
        try {
            this.execUbuntuCommand("sudo shutdown -r now");
            return true;
        }
        catch (IOException e) {
            this.logger.error("Error Reboot the System ", (Throwable)e);
            return false;
        }
    }

    @SuppressFBWarnings(value={"DLS_DEAD_LOCAL_STORE"})
    private static ArrayList<DateTimeFormatter> initFormatters() {
        ArrayList<DateTimeFormatter> formatters = new ArrayList<DateTimeFormatter>();
        long counter = 1L;
        Map<Long, String> monthTexts = Map.ofEntries(Map.entry(counter, "Jan"), Map.entry(++counter, "Feb"), Map.entry(++counter, "M\u00e4r"), Map.entry(++counter, "Apr"), Map.entry(++counter, "Mai"), Map.entry(++counter, "Jun"), Map.entry(++counter, "Jul"), Map.entry(++counter, "Aug"), Map.entry(++counter, "Sep"), Map.entry(++counter, "Okt"), Map.entry(++counter, "Nov"), Map.entry(++counter, "Dez"));
        formatters.add(new DateTimeFormatterBuilder().parseCaseInsensitive().appendText((TemporalField)ChronoField.MONTH_OF_YEAR, monthTexts).appendPattern("  d HH:mm:ss yyyy").toFormatter(Locale.ENGLISH).withLocale(Locale.ENGLISH));
        formatters.add(new DateTimeFormatterBuilder().parseCaseInsensitive().parseLenient().appendPattern("MMM d hh:mm:ss yyyy").toFormatter(Locale.ENGLISH));
        formatters.add(new DateTimeFormatterBuilder().parseCaseInsensitive().parseLenient().appendPattern("[dd][d] [MMMM][MMM][MM][M] yyyy [hh][h]:mm:ss a [z][x][Z]").toFormatter(Locale.ENGLISH));
        formatters.add(new DateTimeFormatterBuilder().parseCaseInsensitive().parseLenient().appendPattern("[dd][d] [MMMM][MMM][MM][M] yyyy [HH][H]:mm:ss [z][x][Z]").toFormatter(Locale.ENGLISH));
        formatters.add(new DateTimeFormatterBuilder().parseCaseInsensitive().appendPattern("[dd][d] ").appendText((TemporalField)ChronoField.MONTH_OF_YEAR, monthTexts).appendPattern(" yyyy [hh][h]:[mm][m]:[ss][s] a [z][x][Z]").toFormatter(Locale.ENGLISH));
        formatters.add(new DateTimeFormatterBuilder().parseCaseInsensitive().appendPattern("[dd][d] ").appendText((TemporalField)ChronoField.MONTH_OF_YEAR, monthTexts).appendPattern(" yyyy [HH][H]:[mm][m]:[ss][s] [z][x][Z]").toFormatter(Locale.ENGLISH));
        formatters.add(new DateTimeFormatterBuilder().parseCaseInsensitive().appendPattern("[dd][d] ").appendText((TemporalField)ChronoField.MONTH_OF_YEAR, monthTexts).appendPattern(" yyyy [hh][h]:[mm][m]:[ss][s] a [z][x][Z]").toFormatter(Locale.GERMAN).withLocale(Locale.GERMAN));
        formatters.add(new DateTimeFormatterBuilder().parseCaseInsensitive().appendPattern("[dd][d] ").appendText((TemporalField)ChronoField.MONTH_OF_YEAR, monthTexts).appendPattern(" yyyy [HH][H]:[mm][m]:[ss][s] [z][x][Z]").toFormatter(Locale.GERMAN).withLocale(Locale.GERMAN));
        formatters.add(new DateTimeFormatterBuilder().parseCaseInsensitive().appendPattern("[dd][d] [MMMM][MMM][MM][M] yyyy [hh][h]:[mm][m]:[ss][s] a [z][x][Z]").toFormatter(Locale.GERMAN).withLocale(Locale.GERMAN));
        formatters.add(new DateTimeFormatterBuilder().parseCaseInsensitive().appendPattern("[dd][d] [MMMM][MMM][MM][M] yyyy [HH][H]:[mm][m]:[ss][s] [z][x][Z]").toFormatter(Locale.GERMAN).withLocale(Locale.GERMAN));
        return formatters;
    }

    public Optional<String> getPrinterUrl() {
        try {
            String answer = this.execUbuntuCommand("lpinfo -v");
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)answer)) {
                List listOfConnections = Arrays.stream(answer.split("\n")).filter(x -> x.startsWith("network ipp:")).filter(x -> x.contains("Brother%20HL-L2400DW")).collect(Collectors.toList());
                this.logger.debug("ipp Brother_HL-L2400DW printers list: {}", listOfConnections);
                Stream<Object> ipps = listOfConnections.stream();
                if (listOfConnections.size() > 1) {
                    ipps = ipps.filter(x -> x.toUpperCase().contains("USB"));
                }
                return ipps.findAny().map(x -> x.replaceFirst("network ipp:", "ipp:"));
            }
        }
        catch (IOException e) {
            this.logger.error("Can not find printer url. LPINFO finished with error", (Throwable)e);
        }
        return Optional.empty();
    }

    public void createPrinter(String name, String url, String driverPath) {
        this.logger.info("createPrinter name - {}, url={}, driverPath-{}", new Object[]{name, url, driverPath});
        try {
            this.execUbuntuCommand(String.format("lpadmin -p %s -E -v \"%s\" -m %s", name, url, driverPath));
        }
        catch (Exception e) {
            this.logger.error("Can not add printer", (Throwable)e);
        }
    }

    public void removePrinter(String printerName) {
        this.logger.info("removePrinter printerName - {}", (Object)printerName);
        try {
            this.execUbuntuCommand(String.format("lpadmin -x %s", printerName));
        }
        catch (Exception e) {
            this.logger.error("Can not remove printer", (Throwable)e);
        }
    }

    public String getMemoryInfo() {
        try {
            return this.execUbuntuCommand("df -h");
        }
        catch (Exception e) {
            this.logger.error("Can not get memory info", (Throwable)e);
            return "";
        }
    }

    @Generated
    public static boolean isRestartingServicesDone() {
        return restartingServicesDone;
    }

    @Generated
    public static void setRestartingServicesDone(boolean restartingServicesDone) {
        ExecuteCommandHelper.restartingServicesDone = restartingServicesDone;
    }
}

