/*
 * Decompiled with CFR 0.152.
 */
package de.alamos.ioespa.espa;

import de.alamos.ioespa.data.config.EspaConfig;
import de.alamos.ioespa.espa.EspaCommunicator;
import de.alamos.ioespa.espa.utils.AbstractPortInput;
import de.alamos.ioespa.espa.utils.SerialLogCollector;
import java.time.LocalDateTime;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class ESPAInput
extends AbstractPortInput {
    private EspaCommunicator communicator;
    private final SerialLogCollector serialLogCollector;

    public ESPAInput(EspaConfig espaConfig, SerialLogCollector serialLogCollector) {
        super(espaConfig);
        this.serialLogCollector = serialLogCollector;
    }

    public String toString() {
        return "ESPA";
    }

    protected void newDataAvailable(byte[] buffer) {
        if (this.communicator != null) {
            this.communicator.handleInput(buffer);
        }
    }

    protected void afterComStarted() {
        this.communicator = new EspaCommunicator(this.getPort(), this.serialLogCollector);
    }

    public List<String> getLastAlarms() {
        if (this.communicator == null) {
            return List.of();
        }
        return this.communicator.getLastAlarmTexts();
    }

    public boolean hasEspaHeartbeat() {
        if (this.communicator == null) {
            return false;
        }
        return this.communicator.hasEspaHeartbeat();
    }

    @Nullable
    public LocalDateTime getLastHeartbeat() {
        if (this.communicator != null) {
            return this.communicator.getLastHeartbeat();
        }
        return null;
    }
}

