/*
 * Decompiled with CFR 0.152.
 */
package de.alamos.ioespa.rest.controller.ioprint;

import de.alamos.ioespa.IOEspaApplication;
import de.alamos.ioespa.data.config.SetupWizardConfig;
import de.alamos.ioespa.helper.ExecuteCommandHelper;
import de.alamos.ioespa.helper.LoggerHelper;
import de.alamos.ioespa.rest.controller.ioprint.FileSystemInfo;
import de.alamos.ioespa.rest.requests.StringConfigRequest;
import de.alamos.ioespa.rest.responses.status.EAppName;
import de.alamos.ioespa.rest.responses.status.StatusResponse;
import de.alamos.ioespa.services.config.ConfigurationService;
import de.alamos.ioespa.services.ioprint.IOPrintStatusInfoService;
import de.alamos.ioespa.services.ioprint.PrinterService;
import java.io.File;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@Profile(value={"print"})
public class StatusController {
    private final Logger logger = LoggerHelper.getLogger(this.getClass());
    private final IOPrintStatusInfoService statusInfoService;
    private final PrinterService printerService;
    private final ConfigurationService configurationService;
    @Value(value="${supportMultiplePrinters}")
    private boolean supportMultiplePrinters;

    public StatusController(IOPrintStatusInfoService statusInfoService, PrinterService printerService, ConfigurationService configurationService, ExecuteCommandHelper commandHelper) {
        this.statusInfoService = statusInfoService;
        this.printerService = printerService;
        this.configurationService = configurationService;
    }

    @GetMapping(value={"/status"})
    public String getSystemStatus(Model model, String error) {
        if (error != null) {
            model.addAttribute("error", (Object)error);
        }
        StatusResponse statusResponse = this.statusInfoService.getSystemStatus();
        ArrayList<FileSystemInfo> fileSysInfo = new ArrayList<FileSystemInfo>();
        for (Path root : FileSystems.getDefault().getRootDirectories()) {
            try {
                File store = root.toFile();
                FileSystemInfo systemInfo = new FileSystemInfo(root.toString(), store.getTotalSpace(), store.getFreeSpace());
                fileSysInfo.add(systemInfo);
                this.logger.info("System Space Info added '{}'", (Object)systemInfo);
            }
            catch (Exception e) {
                fileSysInfo.add(new FileSystemInfo(root.toString(), 0L, 0L));
                this.logger.error("Can not get System Space Info for {}", (Object)root, (Object)e);
            }
        }
        model.addAttribute("fileSysInfo", fileSysInfo);
        model.addAttribute("response", (Object)statusResponse);
        model.addAttribute("response", (Object)statusResponse);
        model.addAttribute("response", (Object)statusResponse);
        model.addAttribute("isRestartingServicesDone", (Object)this.printerService.isRestartingServicesDone());
        SetupWizardConfig setupWizardConfig = this.configurationService.loadAppSetupWizard();
        if (!setupWizardConfig.isFinish()) {
            return "redirect:/set_up";
        }
        model.addAttribute("SUPPORT_MULTIPLE_PRINTERS", (Object)this.supportMultiplePrinters);
        model.addAttribute("config", (Object)new StringConfigRequest());
        model.addAttribute("appName", (Object)EAppName.IOPrint);
        return "status";
    }

    @GetMapping(value={"/disablePrinter"})
    public String disablePrinter(@RequestParam(value="printerName") String printerName, @RequestParam(value="isConnected") Boolean isConnected) {
        this.printerService.disablePrinter(printerName, isConnected.booleanValue());
        return "redirect:/status";
    }

    @GetMapping(value={"/restart"})
    public String restart(RedirectAttributes redirAttrs) {
        this.logger.info("Anwendung wird neu gestartet...");
        IOEspaApplication.restart();
        redirAttrs.addFlashAttribute("success", (Object)"Anwendung wird neu gestartet");
        return "redirect:/status ";
    }
}

