/*
 * Decompiled with CFR 0.152.
 */
package de.alamos.ioespa.rest.controller;

import de.alamos.ioespa.data.config.SetupWizardConfig;
import de.alamos.ioespa.helper.LoggerHelper;
import de.alamos.ioespa.rest.responses.status.EAppName;
import de.alamos.ioespa.services.UpdatingService;
import de.alamos.ioespa.services.config.ConfigurationService;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
public class UpdatingController {
    private final Logger logger = LoggerHelper.getLogger(this.getClass());
    private final UpdatingService service;
    private final ConfigurationService configurationService;
    @Value(value="${update.api.key}")
    private String updateApiKey;

    public UpdatingController(UpdatingService service, ConfigurationService configurationService) {
        this.service = service;
        this.configurationService = configurationService;
    }

    @PostMapping(value={"/update"})
    public String update(RedirectAttributes redirAttrs, @RequestParam(name="folder") String folder) {
        this.logger.debug("Start Updating /update?folder={}", (Object)folder);
        folder = folder.trim();
        if (!StringUtils.hasLength((String)folder)) {
            redirAttrs.addFlashAttribute("error", (Object)"Update-Code darf nicht leer sein");
            return "redirect:/update";
        }
        if (this.service.update(folder)) {
            redirAttrs.addFlashAttribute("isRebootNeeded", (Object)true);
            redirAttrs.addFlashAttribute("success", (Object)"Das Update startet in k\u00fcrze automatisch. IOprint wird anschlie\u00dfend neu gestartet.");
        } else {
            redirAttrs.addFlashAttribute("error", (Object)"Fehler beim schreiben der Update Datei");
        }
        return "redirect:/update";
    }

    @GetMapping(value={"/update"})
    public String getUpdatePage(Model model) {
        SetupWizardConfig setupWizardConfig = this.configurationService.loadAppSetupWizard();
        if (!setupWizardConfig.isFinish()) {
            return "redirect:/set_up";
        }
        model.addAttribute("appName", (Object)EAppName.IOPrint);
        model.addAttribute("defaultPassword", (Object)(!this.configurationService.loadCredentials().isWasChanged() ? 1 : 0));
        return "update";
    }

    @GetMapping(value={"/update/result"})
    @ResponseBody
    public ResponseEntity<String> setUpdateResult(@RequestParam(name="api_key") String apiKey, @RequestParam(name="status") String status, @RequestParam(name="update_version") String updateVersion) {
        if (!this.updateApiKey.equals(apiKey)) {
            this.logger.debug("Response received from update script with Invalid API key: key={} (INVALID) status={} updateVersion={}", new Object[]{LoggerHelper.maskSensitiveValue((String)apiKey), status, updateVersion});
        } else {
            this.logger.debug("Response received from update script: key={} (VALID) status={} updateVersion={}", new Object[]{LoggerHelper.maskSensitiveValue((String)apiKey), status, updateVersion});
        }
        return ResponseEntity.ok((Object)"Response received ok");
    }
}

