/*
 * Decompiled with CFR 0.152.
 */
package de.alamos.ioespa.services.ioespa;

import de.alamos.ioespa.helper.LoggerHelper;
import de.alamos.ioespa.services.HeartbeatService;
import de.alamos.ioespa.services.MqttService;
import de.alamos.ioespa.services.ioespa.AlarmService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

@Component
@Profile(value={"espa"})
public class HeartbeatServiceEspa
implements HeartbeatService {
    public static final int HEARTBEAT_SCHEDULE_IN_M = 5;
    private final Logger logger = LoggerHelper.getLogger(this.getClass());
    private final MqttService mqttService;
    private final ScheduledExecutorService executorService;
    private final AlarmService alarmService;

    public HeartbeatServiceEspa(MqttService mqttService, AlarmService alarmService) {
        this.mqttService = mqttService;
        this.alarmService = alarmService;
        this.executorService = Executors.newScheduledThreadPool(1);
    }

    public void scheduleHeartbeat() {
        this.executorService.scheduleAtFixedRate(() -> this.sendHeartbeat(), 0L, 5L, TimeUnit.MINUTES);
    }

    private void sendHeartbeat() {
        this.logger.info("Sende Heartbeat...");
        this.alarmService.handleHeartbeat();
        try {
            this.mqttService.handleHeartbeat();
        }
        catch (Exception e) {
            this.logger.error("Heartbeat konnte nicht via MQTT verschickt werden", (Throwable)e);
        }
    }
}

