/*
 * Decompiled with CFR 0.152.
 */
package de.alamos.ioespa.services.config;

import de.alamos.ioespa.data.config.ConfigFile;
import de.alamos.ioespa.data.config.HttpAlarmConfig;
import de.alamos.ioespa.helper.PropertyFileHelper;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.util.Optional;
import java.util.Properties;
import org.springframework.stereotype.Service;

@Service
public class HttpAlarmConfigService {
    private final File propertyFile = new File("config/httpAlarm.properties");
    private HttpAlarmConfig httpAlarmConfig;

    public void updateConfig(HttpAlarmConfig httpAlarmConfig) {
        this.httpAlarmConfig = httpAlarmConfig;
        PropertyFileHelper.storeInFile((ConfigFile)httpAlarmConfig, (File)this.propertyFile);
    }

    public HttpAlarmConfig getHttpAlarmConfig() {
        if (this.httpAlarmConfig == null) {
            this.httpAlarmConfig = this.loadHttpAlarmConfig();
        }
        return this.httpAlarmConfig;
    }

    private HttpAlarmConfig loadHttpAlarmConfig() {
        Optional opt = PropertyFileHelper.loadProperties((File)this.propertyFile);
        if (opt.isPresent()) {
            this.httpAlarmConfig = new HttpAlarmConfig((Properties)opt.get());
            return this.httpAlarmConfig;
        }
        this.httpAlarmConfig = new HttpAlarmConfig();
        PropertyFileHelper.storeInFile((ConfigFile)this.httpAlarmConfig, (File)this.propertyFile);
        return this.httpAlarmConfig;
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
    public void resetToFactoryDefaults() {
        this.propertyFile.delete();
    }
}

