/*
 * Decompiled with CFR 0.152.
 */
package de.alamos.ioespa.rest.controller.ioprint;

import de.alamos.ioespa.IOEspaApplication;
import de.alamos.ioespa.data.config.EWizardStep;
import de.alamos.ioespa.data.config.IOCredentials;
import de.alamos.ioespa.helper.LoggerHelper;
import de.alamos.ioespa.rest.requests.PasswordChangeRequest;
import de.alamos.ioespa.rest.requests.StringConfigRequest;
import de.alamos.ioespa.rest.responses.status.EAppName;
import de.alamos.ioespa.services.VersionService;
import de.alamos.ioespa.services.ioprint.WizardService;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@Profile(value={"print"})
public class WizardController {
    public static final int STEP = 6;
    public static final int NEED_RESTART_STEP = 6;
    private final Logger logger = LoggerHelper.getLogger(this.getClass());
    private final IOCredentials credentials;
    private final WizardService wizardService;
    private final VersionService versionService;
    @Value(value="${defaultPassword}")
    private String defaultPassword;

    public WizardController(IOCredentials credentials, WizardService wizardService, VersionService versionService) {
        this.credentials = credentials;
        this.wizardService = wizardService;
        this.versionService = versionService;
    }

    @GetMapping(value={"/set_up"})
    public String getSystemStatus(Model model) {
        if (this.wizardService.isSetUpFinished()) {
            return "redirect:/status";
        }
        model.addAttribute("setupWizard", (Object)this.wizardService.setupProgress());
        model.addAttribute("isRestartingServicesDone", (Object)this.wizardService.isRestartingServicesDone());
        model.addAttribute("config", (Object)new StringConfigRequest());
        model.addAttribute("configPass", (Object)new PasswordChangeRequest());
        model.addAttribute("appName", (Object)EAppName.IOPrint);
        model.addAttribute("defaultPassword", (Object)this.defaultPassword);
        model.addAttribute("appVersion", (Object)this.versionService.getCurrentVersion());
        return "set_up";
    }

    @PostMapping(value={"/wizardConfigString"})
    public String postConfig(@ModelAttribute StringConfigRequest config, @RequestParam(value="Authorization", required=false) String authorization, RedirectAttributes redirAttrs) {
        this.wizardService.updateStep(EWizardStep.CONFIGURATION_SAVED);
        if (!this.credentials.checkPassword(authorization)) {
            redirAttrs.addFlashAttribute("error", (Object)"Nicht autorisiert");
            return "redirect:/set_up";
        }
        this.wizardService.postConfig(config);
        return "redirect:/set_up";
    }

    @GetMapping(value={"/wizardReinstallPrinters"})
    public String reinstallPrinters(@RequestParam(value="Authorization", required=false) String authorization, RedirectAttributes redirAttrs) {
        if (!this.credentials.checkPassword(authorization)) {
            redirAttrs.addFlashAttribute("error", (Object)"Nicht autorisiert");
            return "redirect:/set_up";
        }
        this.wizardService.reinstallPrinters();
        this.wizardService.updateStep(EWizardStep.CHECK_PRINTERS);
        return "redirect:/set_up";
    }

    @GetMapping(value={"/wizardTestLocalChecked"})
    public String wizardTestLocalChecked(RedirectAttributes redirAttrs, @RequestParam(value="Authorization", required=false) String authorization) {
        if (!this.credentials.checkPassword(authorization)) {
            redirAttrs.addFlashAttribute("error", (Object)"Nicht autorisiert");
            return "redirect:/set_up";
        }
        this.wizardService.localTestChecked();
        return "redirect:/set_up";
    }

    @GetMapping(value={"/wizardTestFE2Checked"})
    public String wizardTestFE2Checked(RedirectAttributes redirAttrs, @RequestParam(value="Authorization", required=false) String authorization) {
        if (!this.credentials.checkPassword(authorization)) {
            redirAttrs.addFlashAttribute("error", (Object)"Nicht autorisiert");
            return "redirect:/set_up";
        }
        this.wizardService.fe2TestChecked();
        return "redirect:/set_up";
    }

    @GetMapping(value={"/wizardFinal"})
    public String wizardFinal(RedirectAttributes redirAttrs) {
        this.wizardService.finish();
        return "redirect:/set_up";
    }

    @GetMapping(value={"/wizardRestart"})
    public String wizardRestart(RedirectAttributes redirAttrs, @RequestParam(value="Authorization") String authorization) {
        int step = this.wizardService.getStep();
        if (!this.credentials.checkPassword(authorization)) {
            redirAttrs.addFlashAttribute("error", (Object)"Nicht autorisiert");
            if (step == 6) {
                this.wizardService.updateStep(EWizardStep.NEED_RESTART);
            }
            return "redirect:/set_up";
        }
        this.logger.info("Anwendung wird neu gestartet...");
        if (step == 6) {
            this.wizardService.updateStep(EWizardStep.MQTT_CHECK);
        }
        IOEspaApplication.restart();
        return "redirect:/set_up";
    }

    @PostMapping(value={"/wizardPassword"})
    public String wizardPassword(@ModelAttribute PasswordChangeRequest request, @RequestParam(value="Authorization", required=false) String authorization, RedirectAttributes redirAttrs) {
        if (!this.credentials.checkPassword(authorization)) {
            redirAttrs.addFlashAttribute("error", (Object)"Nicht autorisiert");
            this.wizardService.updateStep(EWizardStep.CHANGE_PASSWORD_FINISHED);
            return "redirect:/set_up";
        }
        this.wizardService.changePassword(request);
        return "redirect:/set_up";
    }
}

