/*
 * Decompiled with CFR 0.152.
 */
package de.alamos.ioespa.rest.controller.ioprint;

import de.alamos.ioespa.services.ioprint.PrinterService;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;

@Controller
@Profile(value={"print"})
public class PrintersController {
    private final PrinterService printerService;

    public PrintersController(PrinterService printerService) {
        this.printerService = printerService;
    }

    @GetMapping(value={"/reinstallPrinters"})
    public String reinstallPrinters() {
        this.printerService.removeAllPrinters();
        this.printerService.createPrinter();
        return "redirect:/status";
    }

    @GetMapping(value={"/restartCups"})
    public String restartCups() {
        this.printerService.restartCups();
        return "redirect:/status";
    }

    @GetMapping(value={"/clearAllJobs/{printerName}"})
    public String clearAllJobs(@PathVariable String printerName) {
        this.printerService.clearAllJobs(printerName);
        return "redirect:/status";
    }
}

