/*
 * Decompiled with CFR 0.152.
 */
package de.alamos.ioespa.rest.controller;

import de.alamos.ioespa.helper.LoggerHelper;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.lingala.zip4j.ZipFile;
import net.lingala.zip4j.model.ZipParameters;
import org.apache.tomcat.util.http.fileupload.IOUtils;
import org.slf4j.Logger;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class LogsController {
    private final Logger logger = LoggerHelper.getLogger(this.getClass());

    @GetMapping(value={"/logs"})
    public void getLogs(HttpServletResponse response) throws IOException {
        response.setHeader("Content-Disposition", "attachment;filename=\"logs.zip\"");
        response.setContentType("application/octet-stream");
        response.setStatus(200);
        File zip = this.zipLogs();
        try (FileInputStream in = new FileInputStream(zip);){
            ServletOutputStream out = response.getOutputStream();
            IOUtils.copy((InputStream)in, (OutputStream)out);
            out.close();
            boolean deleted = zip.delete();
            this.logger.debug("ZIP delete: {}", (Object)deleted);
        }
    }

    private File zipLogs() throws IOException {
        File[] logFiles = new File("logs").listFiles();
        if (logFiles == null) {
            this.logger.warn("Der Ordner \"logs\" wurde nicht gefunden");
            throw new NullPointerException("Keine Logs gefunden");
        }
        this.logger.trace("Logdateien werden in ZIP verpackt");
        File output = new File("logs.zip");
        if (output.exists()) {
            boolean deleted = output.delete();
            this.logger.debug("{} deleted: {}", (Object)output.getAbsolutePath(), (Object)deleted);
        }
        ZipFile zipFile = new ZipFile(output);
        ZipParameters zipParameters = new ZipParameters();
        for (File logFile : logFiles) {
            zipFile.addFile(logFile, zipParameters);
        }
        zipFile.close();
        return output;
    }
}

